/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.location;

import org.junit.Assert;
import org.junit.Test;
import org.scijava.io.location.BytesLocation;

public class BytesLocationTest {
    @Test
    public void testBytes() {
        byte[] digits = new byte[]{3, 1, 4, 1, 5, 9, 2, 6, 5, 3, 5, 8, 9, 7, 9};
        BytesLocation loc = new BytesLocation(digits);
        byte[] testDigits = new byte[digits.length];
        loc.getByteBank().getBytes(0L, testDigits);
        Assert.assertEquals((long)digits.length, (long)loc.getByteBank().size());
        Assert.assertArrayEquals((byte[])digits, (byte[])testDigits);
    }

    @Test
    public void testBytesOffsetLength() {
        byte[] digits = new byte[]{3, 1, 4, 1, 5, 9, 2, 6, 5, 3, 5, 8, 9, 7, 9};
        int offset = 3;
        int length = 5;
        BytesLocation loc = new BytesLocation(digits, 3, 5);
        byte[] testDigits = new byte[digits.length];
        loc.getByteBank().getBytes(0L, testDigits);
        Assert.assertEquals((long)5L, (long)loc.getByteBank().size());
        byte[] expectedDigits = new byte[digits.length];
        System.arraycopy(digits, 3, expectedDigits, 0, 5);
        Assert.assertArrayEquals((byte[])expectedDigits, (byte[])testDigits);
    }
}

