/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.location;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;

public class FileLocationResolverTest {
    Context ctx = new Context(new Class[]{LocationService.class});
    LocationService resolver = (LocationService)this.ctx.getService(LocationService.class);

    @Test
    public void testStringResolve() throws URISyntaxException {
        String uri = new File(new File(".").getAbsolutePath()).toURI().toString();
        Location loc = this.resolver.resolve(uri);
        Assert.assertTrue((boolean)(loc instanceof FileLocation));
        Assert.assertEquals((Object)uri, (Object)loc.getURI().toString());
    }

    @Test
    public void testURIResolve() throws URISyntaxException {
        URI uri = new File(new File(".").getAbsolutePath()).toURI();
        Location loc = this.resolver.resolve(uri);
        Assert.assertTrue((boolean)(loc instanceof FileLocation));
        Assert.assertEquals((Object)uri, (Object)loc.getURI());
    }
}

