/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.StringUtils;

public class StringUtilsTest {
    @Test
    public void testSplitUnquoted() {
        String line = "foo,bar,c;qual=\"baz,blurb\",d;junk=\"quux,syzygy\"";
        Object[] expected = new String[]{"foo", "bar", "c;qual=\"baz,blurb\"", "d;junk=\"quux,syzygy\""};
        Object[] actual = StringUtils.splitUnquoted((String)"foo,bar,c;qual=\"baz,blurb\",d;junk=\"quux,syzygy\"", (String)",");
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void isNullOrEmptyFalseIfString() throws Exception {
        Assert.assertFalse((boolean)StringUtils.isNullOrEmpty((String)"Fresh out of Red Leicester"));
    }

    @Test
    public void isNullOrEmpty() throws Exception {
        Assert.assertTrue((boolean)StringUtils.isNullOrEmpty(null));
        Assert.assertTrue((boolean)StringUtils.isNullOrEmpty((String)""));
    }

    @Test
    public void padEndNullStringReturnsNull() throws Exception {
        Assert.assertNull((Object)StringUtils.padEnd(null, (int)5, (char)'*'));
    }

    @Test
    public void padEndEmptyString() throws Exception {
        int length = 5;
        int padChar = 42;
        String padded = StringUtils.padEnd((String)"", (int)5, (char)'*');
        Assert.assertNotNull((Object)padded);
        Assert.assertFalse((boolean)padded.isEmpty());
        Assert.assertEquals((long)5L, (long)padded.length());
        Assert.assertTrue((boolean)padded.chars().allMatch(c -> c == 42));
    }

    @Test
    public void padEndLengthSmaller() throws Exception {
        String s = "Eric the fruit bat";
        String padded = StringUtils.padEnd((String)"Eric the fruit bat", (int)3, (char)'*');
        Assert.assertEquals((Object)"Eric the fruit bat", (Object)padded);
    }

    @Test
    public void padEndLengthEqual() throws Exception {
        String s = "Eric the cat";
        String padded = StringUtils.padEnd((String)"Eric the cat", (int)"Eric the cat".length(), (char)'*');
        Assert.assertEquals((Object)"Eric the cat", (Object)padded);
    }

    @Test
    public void padEndLengthNegative() throws Exception {
        String s = "Eric the dog";
        String padded = StringUtils.padEnd((String)"Eric the dog", (int)-1, (char)'~');
        Assert.assertEquals((Object)"Eric the dog", (Object)padded);
    }

    @Test
    public void padEnd() throws Exception {
        String s = "Eric the halibut";
        int newLength = "Eric the halibut".length() + 5;
        String padded = StringUtils.padEnd((String)"Eric the halibut", (int)newLength);
        Assert.assertEquals((long)newLength, (long)padded.length());
        String padding = padded.substring(padded.length() - 5);
        Assert.assertTrue((boolean)padding.chars().allMatch(c -> c == 32));
        Assert.assertEquals((Object)"Eric the halibut", (Object)padded.substring(0, padded.length() - 5));
    }

    @Test
    public void padStartNullStringReturnsNull() throws Exception {
        Assert.assertNull((Object)StringUtils.padStart(null, (int)5, (char)'*'));
    }

    @Test
    public void padStartEmptyString() throws Exception {
        int length = 5;
        int padChar = 42;
        String padded = StringUtils.padStart((String)"", (int)5, (char)'*');
        Assert.assertNotNull((Object)padded);
        Assert.assertFalse((boolean)padded.isEmpty());
        Assert.assertEquals((long)5L, (long)padded.length());
        Assert.assertTrue((boolean)padded.chars().allMatch(c -> c == 42));
    }

    @Test
    public void padStartLengthSmaller() throws Exception {
        String s = "Eric the dog";
        String padded = StringUtils.padStart((String)"Eric the dog", (int)3, (char)'*');
        Assert.assertEquals((Object)"Eric the dog", (Object)padded);
    }

    @Test
    public void padStartLengthEqual() throws Exception {
        String s = "Simon the prawn";
        String padded = StringUtils.padStart((String)"Simon the prawn", (int)"Simon the prawn".length(), (char)'*');
        Assert.assertEquals((Object)"Simon the prawn", (Object)padded);
    }

    @Test
    public void padStartLengthNegative() throws Exception {
        String s = "Norman the pike";
        String padded = StringUtils.padStart((String)"Norman the pike", (int)-1, (char)'~');
        Assert.assertEquals((Object)"Norman the pike", (Object)padded);
    }

    @Test
    public void padStart() throws Exception {
        String s = "Norman the pike";
        int newLength = "Norman the pike".length() + 5;
        String padded = StringUtils.padStart((String)"Norman the pike", (int)newLength);
        Assert.assertEquals((long)newLength, (long)padded.length());
        String padding = padded.substring(0, 5);
        Assert.assertTrue((boolean)padding.chars().allMatch(c -> c == 32));
        Assert.assertEquals((Object)"Norman the pike", (Object)padded.substring(5, padded.length()));
    }
}

