/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.test.TestUtils;
import org.scijava.util.FileUtils;
import org.scijava.util.Types;

public class TypesTest {
    @Test
    public void testLoad() {
        this.assertLoaded(Boolean.TYPE, "boolean");
        this.assertLoaded(Byte.TYPE, "byte");
        this.assertLoaded(Character.TYPE, "char");
        this.assertLoaded(Double.TYPE, "double");
        this.assertLoaded(Float.TYPE, "float");
        this.assertLoaded(Integer.TYPE, "int");
        this.assertLoaded(Long.TYPE, "long");
        this.assertLoaded(Short.TYPE, "short");
        this.assertLoaded(Void.TYPE, "void");
        this.assertLoaded(String.class, "string");
        this.assertLoaded(Number.class, "java.lang.Number");
        this.assertLoaded(boolean[].class, "boolean[]");
        this.assertLoaded(byte[].class, "byte[]");
        this.assertLoaded(char[].class, "char[]");
        this.assertLoaded(double[].class, "double[]");
        this.assertLoaded(float[].class, "float[]");
        this.assertLoaded(int[].class, "int[]");
        this.assertLoaded(long[].class, "long[]");
        this.assertLoaded(short[].class, "short[]");
        this.assertLoaded(null, "void[]");
        this.assertLoaded(String[].class, "string[]");
        this.assertLoaded(Number[].class, "java.lang.Number[]");
        this.assertLoaded(boolean[][].class, "boolean[][]");
        this.assertLoaded(byte[][].class, "byte[][]");
        this.assertLoaded(char[][].class, "char[][]");
        this.assertLoaded(double[][].class, "double[][]");
        this.assertLoaded(float[][].class, "float[][]");
        this.assertLoaded(int[][].class, "int[][]");
        this.assertLoaded(long[][].class, "long[][]");
        this.assertLoaded(short[][].class, "short[][]");
        this.assertLoaded(null, "void[][]");
        this.assertLoaded(String[][].class, "string[][]");
        this.assertLoaded(Number[][].class, "java.lang.Number[][]");
        this.assertLoaded(boolean[].class, "[Z");
        this.assertLoaded(byte[].class, "[B");
        this.assertLoaded(char[].class, "[C");
        this.assertLoaded(double[].class, "[D");
        this.assertLoaded(float[].class, "[F");
        this.assertLoaded(int[].class, "[I");
        this.assertLoaded(long[].class, "[J");
        this.assertLoaded(short[].class, "[S");
        this.assertLoaded(null, "[V");
        this.assertLoaded(String[].class, "[Lstring;");
        this.assertLoaded(Number[].class, "[Ljava.lang.Number;");
        this.assertLoaded(boolean[][].class, "[[Z");
        this.assertLoaded(byte[][].class, "[[B");
        this.assertLoaded(char[][].class, "[[C");
        this.assertLoaded(double[][].class, "[[D");
        this.assertLoaded(float[][].class, "[[F");
        this.assertLoaded(int[][].class, "[[I");
        this.assertLoaded(long[][].class, "[[J");
        this.assertLoaded(short[][].class, "[[S");
        this.assertLoaded(null, "[[V");
        this.assertLoaded(String[][].class, "[[Lstring;");
        this.assertLoaded(Number[][].class, "[[Ljava.lang.Number;");
    }

    @Test
    public void testLoadFailureQuiet() {
        Assert.assertNull((Object)Types.load((String)"a.non.existent.class"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLoadFailureLoud() {
        Types.load((String)"a.non.existent.class", (boolean)false);
    }

    @Test
    public void testLocationUnpackedClass() throws IOException {
        String path;
        File tmpDir = TestUtils.createTemporaryDirectory((String)"class-utils-test-");
        File classFile = new File(tmpDir, path = this.getClass().getName().replace('.', '/') + ".class");
        Assert.assertTrue((classFile.getParentFile().exists() || classFile.getParentFile().mkdirs() ? 1 : 0) != 0);
        this.copy(this.getClass().getResource("/" + path).openStream(), new FileOutputStream(classFile), true);
        URLClassLoader classLoader = new URLClassLoader(new URL[]{tmpDir.toURI().toURL()}, null);
        Class c = Types.load((String)this.getClass().getName(), (ClassLoader)classLoader);
        URL location = Types.location((Class)c);
        Assert.assertEquals((Object)tmpDir, (Object)FileUtils.urlToFile((URL)location));
        FileUtils.deleteRecursively((File)tmpDir);
    }

    @Test
    public void testLocationClassInJar() throws IOException {
        File tmpDir = TestUtils.createTemporaryDirectory((String)"class-utils-test-");
        File jar = new File(tmpDir, "test.jar");
        JarOutputStream out = new JarOutputStream(new FileOutputStream(jar));
        String path = this.getClass().getName().replace('.', '/') + ".class";
        out.putNextEntry(new ZipEntry(path));
        this.copy(this.getClass().getResource("/" + path).openStream(), out, true);
        URLClassLoader classLoader = new URLClassLoader(new URL[]{jar.toURI().toURL()}, null);
        Class c = Types.load((String)this.getClass().getName(), (ClassLoader)classLoader);
        URL location = Types.location((Class)c);
        Assert.assertEquals((Object)jar, (Object)FileUtils.urlToFile((URL)location));
        jar.deleteOnExit();
    }

    @Test
    public void testLocationFailureQuiet() {
        Class<?> weirdClass = this.loadCustomClass();
        Assert.assertEquals((Object)"Hello", (Object)weirdClass.getName());
        Assert.assertNull((Object)Types.location(weirdClass));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLocationFailureLoud() {
        Class<?> weirdClass = this.loadCustomClass();
        Assert.assertEquals((Object)"Hello", (Object)weirdClass.getName());
        Types.location(weirdClass, (boolean)false);
    }

    public void testName() {
        Assert.assertEquals((Object)"boolean", (Object)Types.name(Boolean.TYPE));
        Assert.assertEquals((Object)"java.lang.String", (Object)Types.name(String.class));
        class Struct {
            private List<String> list;

            Struct() {
            }
        }
        Assert.assertEquals((Object)"List<String>[]", (Object)Types.name((Type)this.type(Struct.class, "list")));
    }

    @Test
    public void testRaw() {
        class Struct {
            private int[] intArray;
            private double d;
            private String[][] strings;
            private Void v;
            private List<String> list;
            private HashMap<Integer, Float> map;

            Struct() {
            }
        }
        Assert.assertSame(int[].class, this.raw(Struct.class, "intArray"));
        Assert.assertSame(Double.TYPE, this.raw(Struct.class, "d"));
        Assert.assertSame(String[][].class, this.raw(Struct.class, "strings"));
        Assert.assertSame(Void.class, this.raw(Struct.class, "v"));
        Assert.assertSame(List.class, this.raw(Struct.class, "list"));
        Assert.assertSame(HashMap.class, this.raw(Struct.class, "map"));
    }

    @Test
    public void testRaws() {
        Field field = Types.field(Thing.class, (String)"thing");
        this.assertAllTheSame(Types.raws((Type)Types.fieldType((Field)field, Thing.class)), Object.class);
        this.assertAllTheSame(Types.raws((Type)Types.fieldType((Field)field, NumberThing.class)), Number.class);
        this.assertAllTheSame(Types.raws((Type)Types.fieldType((Field)field, IntegerThing.class)), Integer.class);
        this.assertAllTheSame(Types.raws((Type)Types.fieldType((Field)field, ComplexThing.class)), Serializable.class, Cloneable.class);
    }

    @Test
    public void testBox() {
        Class[] types;
        Class booleanType = Types.box(Boolean.TYPE);
        Assert.assertSame(Boolean.class, (Object)booleanType);
        Class byteType = Types.box(Byte.TYPE);
        Assert.assertSame(Byte.class, (Object)byteType);
        Class charType = Types.box(Character.TYPE);
        Assert.assertSame(Character.class, (Object)charType);
        Class doubleType = Types.box(Double.TYPE);
        Assert.assertSame(Double.class, (Object)doubleType);
        Class floatType = Types.box(Float.TYPE);
        Assert.assertSame(Float.class, (Object)floatType);
        Class intType = Types.box(Integer.TYPE);
        Assert.assertSame(Integer.class, (Object)intType);
        Class longType = Types.box(Long.TYPE);
        Assert.assertSame(Long.class, (Object)longType);
        Class shortType = Types.box(Short.TYPE);
        Assert.assertSame(Short.class, (Object)shortType);
        Class voidType = Types.box(Void.TYPE);
        Assert.assertSame(Void.class, (Object)voidType);
        for (Class c : types = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Void.class, String.class, Number.class, BigInteger.class, BigDecimal.class, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class, Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class, Void[].class, Object.class, Object[].class, String[].class, Object[][].class, String[][].class, Collection.class, List.class, ArrayList.class, LinkedList.class, Set.class, HashSet.class, Map.class, HashMap.class, Collection[].class, List[].class, Set[].class, Map[].class}) {
            Class type = Types.box((Class)c);
            Assert.assertSame((Object)c, (Object)type);
        }
    }

    @Test
    public void testNullValue() {
        Class[] types;
        boolean booleanNull = (Boolean)Types.nullValue(Boolean.TYPE);
        Assert.assertFalse((boolean)booleanNull);
        byte byteNull = (Byte)Types.nullValue(Byte.TYPE);
        Assert.assertEquals((long)0L, (long)byteNull);
        char charNull = ((Character)Types.nullValue(Character.TYPE)).charValue();
        Assert.assertEquals((long)0L, (long)charNull);
        double doubleNull = (Double)Types.nullValue(Double.TYPE);
        Assert.assertEquals((double)0.0, (double)doubleNull, (double)0.0);
        float floatNull = ((Float)Types.nullValue(Float.TYPE)).floatValue();
        Assert.assertEquals((float)0.0f, (float)floatNull, (float)0.0f);
        int intNull = (Integer)Types.nullValue(Integer.TYPE);
        Assert.assertEquals((long)0L, (long)intNull);
        long longNull = (Long)Types.nullValue(Long.TYPE);
        Assert.assertEquals((long)0L, (long)longNull);
        short shortNull = (Short)Types.nullValue(Short.TYPE);
        Assert.assertEquals((long)0L, (long)shortNull);
        Void voidNull = (Void)Types.nullValue(Void.TYPE);
        Assert.assertNull((Object)voidNull);
        for (Class c : types = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Void.class, String.class, Number.class, BigInteger.class, BigDecimal.class, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class, Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class, Void[].class, Object.class, Object[].class, String[].class, Object[][].class, String[][].class, Collection.class, List.class, ArrayList.class, LinkedList.class, Set.class, HashSet.class, Map.class, HashMap.class, Collection[].class, List[].class, Set[].class, Map[].class}) {
            Object nullValue = Types.nullValue((Class)c);
            Assert.assertNull((String)("Expected null for " + c.getName()), (Object)nullValue);
        }
    }

    @Test
    public void testField() {
        Field field = Types.field(Thing.class, (String)"thing");
        Assert.assertEquals((Object)"thing", (Object)field.getName());
        Assert.assertSame(Object.class, field.getType());
        Assert.assertTrue((boolean)(field.getGenericType() instanceof TypeVariable));
        Assert.assertEquals((Object)"T", (Object)((TypeVariable)field.getGenericType()).getName());
    }

    @Test
    public void testMethod() {
        Method objectMethod = Types.method(Thing.class, (String)"toString", (Class[])new Class[0]);
        Assert.assertSame(Object.class, objectMethod.getDeclaringClass());
        Assert.assertEquals((Object)"toString", (Object)objectMethod.getName());
        Assert.assertSame(String.class, objectMethod.getReturnType());
        Assert.assertEquals((long)0L, (long)objectMethod.getParameterTypes().length);
        Method wordsMethod = Types.method(Words.class, (String)"valueOf", (Class[])new Class[]{String.class});
        Assert.assertSame(Words.class, wordsMethod.getDeclaringClass());
        Assert.assertEquals((Object)"valueOf", (Object)wordsMethod.getName());
        Assert.assertSame(Words.class, wordsMethod.getReturnType());
        Assert.assertEquals((long)1L, (long)wordsMethod.getParameterTypes().length);
        Assert.assertSame(String.class, wordsMethod.getParameterTypes()[0]);
    }

    @Test
    public void testArray() {
        Assert.assertSame(boolean[].class, (Object)Types.array(Boolean.TYPE));
        Assert.assertSame(String[].class, (Object)Types.array(String.class));
        Assert.assertSame(Number[].class, (Object)Types.array(Number.class));
        Assert.assertSame(boolean[][].class, (Object)Types.array(boolean[].class));
        Assert.assertSame(String[][].class, (Object)Types.array(String[].class));
        Assert.assertSame(Number[][].class, (Object)Types.array(Number[].class));
        try {
            Types.array(Void.TYPE);
            Assert.fail((String)"Unexpected success creating void[]");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertSame(Number[][].class, (Object)Types.array(Number.class, (int)2));
        Assert.assertSame(boolean[][][].class, (Object)Types.array(Boolean.TYPE, (int)3));
        Assert.assertSame(String.class, (Object)Types.array(String.class, (int)0));
        try {
            Types.array(Character.TYPE, (int)-1);
            Assert.fail((String)"Unexpected success creating negative dimensional array");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testComponent() {
        class Struct {
            private int[] intArray;
            private double d;
            private String[][] strings;
            private Void v;
            private List<String>[] list;
            private HashMap<Integer, Float> map;

            Struct() {
            }
        }
        Assert.assertSame(Integer.TYPE, this.componentType(Struct.class, "intArray"));
        Assert.assertNull(this.componentType(Struct.class, "d"));
        Assert.assertSame(String[].class, this.componentType(Struct.class, "strings"));
        Assert.assertSame(null, this.componentType(Struct.class, "v"));
        Assert.assertSame(List.class, this.componentType(Struct.class, "list"));
        Assert.assertSame(null, this.componentType(Struct.class, "map"));
    }

    @Test
    public void testFieldType() {
        Field field = Types.field(Thing.class, (String)"thing");
        Type tType = Types.fieldType((Field)field, Thing.class);
        Assert.assertEquals((Object)"capture of ?", (Object)tType.toString());
        Type nType = Types.fieldType((Field)field, NumberThing.class);
        Assert.assertEquals((Object)"capture of ?", (Object)nType.toString());
        Type iType = Types.fieldType((Field)field, IntegerThing.class);
        Assert.assertSame(Integer.class, (Object)iType);
    }

    @Test
    public void testParam() {
        class Struct {
            private List<int[]> list;

            Struct() {
            }
        }
        Type listType = this.type(Struct.class, "list");
        Type paramType = Types.param((Type)listType, List.class, (int)0);
        Class paramClass = Types.raw((Type)paramType);
        Assert.assertSame(int[].class, (Object)paramClass);
    }

    @Test
    public void testIsAssignable() {
        Assert.assertTrue((boolean)Types.isAssignable(String.class, Object.class));
        Assert.assertTrue((boolean)Types.isAssignable(ArrayList.class, Collection.class));
        Assert.assertFalse((boolean)Types.isAssignable(Double.TYPE, Float.TYPE));
        Assert.assertFalse((boolean)Types.isAssignable(Float.TYPE, Double.TYPE));
        Assert.assertFalse((boolean)Types.isAssignable(Integer.TYPE, Number.class));
        Assert.assertTrue((boolean)Types.isAssignable(null, Object.class));
        Assert.assertTrue((boolean)Types.isAssignable(null, int[].class));
    }

    @Test(expected=NullPointerException.class)
    public void testIsAssignableNullToNull() {
        Types.isAssignable(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testIsAssignableClassToNull() {
        Types.isAssignable(Object.class, null);
    }

    @Test
    public void testIsInstance() {
        Object nullObject = null;
        Assert.assertTrue((boolean)Types.isInstance(nullObject, Object.class));
        Assert.assertTrue((boolean)Types.isInstance(nullObject, int[].class));
        Assert.assertFalse((boolean)Types.isInstance(nullObject, null));
        Assert.assertFalse((boolean)Types.isInstance((Object)new Object(), null));
    }

    @Test
    public void testCast() {
        String string = "Hello";
        Object stringToObject = Types.cast((Object)"Hello", Object.class);
        Assert.assertSame((Object)"Hello", (Object)stringToObject);
        ArrayList arrayList = new ArrayList();
        Collection arrayListToCollection = (Collection)Types.cast(arrayList, Collection.class);
        Assert.assertSame(arrayList, (Object)arrayListToCollection);
        Float doubleToFloat = (Float)Types.cast((Object)5.1, Float.TYPE);
        Assert.assertNull((Object)doubleToFloat);
        Double floatToDouble = (Double)Types.cast((Object)Float.valueOf(5.1f), Double.TYPE);
        Assert.assertNull((Object)floatToDouble);
        Number intToNumber = (Number)Types.cast((Object)5, Number.class);
        Assert.assertSame(Integer.class, intToNumber.getClass());
        Assert.assertEquals((long)5L, (long)intToNumber.intValue());
    }

    @Test
    public void testEnumValue() {
        Words foo = (Words)((Object)Types.enumValue((String)"FOO", Words.class));
        Assert.assertSame((Object)((Object)Words.FOO), (Object)((Object)foo));
        Words bar = (Words)((Object)Types.enumValue((String)"BAR", Words.class));
        Assert.assertSame((Object)((Object)Words.BAR), (Object)((Object)bar));
        Words fubar = (Words)((Object)Types.enumValue((String)"FUBAR", Words.class));
        Assert.assertSame((Object)((Object)Words.FUBAR), (Object)((Object)fubar));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnumValueNoConstant() {
        Types.enumValue((String)"NONE", Words.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnumValueNonEnum() {
        Types.enumValue((String)"HOOYAH", String.class);
    }

    private void copy(InputStream in, OutputStream out, boolean closeOut) throws IOException {
        int count;
        byte[] buffer = new byte[16384];
        while ((count = in.read(buffer)) >= 0) {
            out.write(buffer, 0, count);
        }
        in.close();
        if (closeOut) {
            out.close();
        }
    }

    private Class<?> loadCustomClass() {
        byte[] bytecode = new byte[]{-54, -2, -70, -66, 0, 0, 0, 52, 0, 13, 10, 0, 3, 0, 10, 7, 0, 11, 7, 0, 12, 1, 0, 6, 60, 105, 110, 105, 116, 62, 1, 0, 3, 40, 41, 86, 1, 0, 4, 67, 111, 100, 101, 1, 0, 15, 76, 105, 110, 101, 78, 117, 109, 98, 101, 114, 84, 97, 98, 108, 101, 1, 0, 10, 83, 111, 117, 114, 99, 101, 70, 105, 108, 101, 1, 0, 10, 72, 101, 108, 108, 111, 46, 106, 97, 118, 97, 12, 0, 4, 0, 5, 1, 0, 5, 72, 101, 108, 108, 111, 1, 0, 16, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 79, 98, 106, 101, 99, 116, 0, 33, 0, 2, 0, 3, 0, 0, 0, 0, 0, 1, 0, 1, 0, 4, 0, 5, 0, 1, 0, 6, 0, 0, 0, 29, 0, 1, 0, 1, 0, 0, 0, 5, 42, -73, 0, 1, -79, 0, 0, 0, 1, 0, 7, 0, 0, 0, 6, 0, 1, 0, 0, 0, 1, 0, 1, 0, 8, 0, 0, 0, 2, 0, 9};
        class BytesClassLoader
        extends ClassLoader {
            BytesClassLoader() {
            }

            public Class<?> load(String name, byte[] b) {
                return this.defineClass(name, b, 0, b.length);
            }
        }
        return new BytesClassLoader().load("Hello", bytecode);
    }

    private Type type(Class<?> c, String fieldName) {
        return Types.field(c, (String)fieldName).getGenericType();
    }

    private Class<?> raw(Class<?> c, String fieldName) {
        return Types.raw((Type)this.type(c, fieldName));
    }

    private Class<?> componentType(Class<?> c, String fieldName) {
        return Types.raw((Type)Types.component((Type)this.type(c, fieldName)));
    }

    private void assertLoaded(Class<?> c, String name) {
        Assert.assertSame(c, (Object)Types.load((String)name));
    }

    private void assertAllTheSame(List<?> list, Object ... values) {
        Assert.assertEquals((long)list.size(), (long)values.length);
        for (int i = 0; i < values.length; ++i) {
            Assert.assertSame(list.get(i), (Object)values[i]);
        }
    }

    public static enum Words {
        FOO,
        BAR,
        FUBAR;

    }

    private static class ComplexThing<T extends Serializable & Cloneable>
    extends Thing<T> {
        private ComplexThing() {
        }
    }

    private static class IntegerThing
    extends NumberThing<Integer> {
        private IntegerThing() {
        }
    }

    private static class NumberThing<N extends Number>
    extends Thing<N> {
        private NumberThing() {
        }
    }

    private static class Thing<T> {
        private T thing;

        private Thing() {
        }
    }
}

