/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;

public interface StreamHandle<L extends Location>
extends DataHandle<L> {
    public InputStream in() throws IOException;

    public OutputStream out() throws IOException;

    public void setOffset(long var1);

    default public void advance(long bytes) throws IOException {
        this.setOffset(this.offset() + bytes);
    }

    @Override
    default public void seek(long pos) throws IOException {
        if (pos == this.offset()) {
            return;
        }
        if (pos <= this.offset()) {
            throw new UnsupportedOperationException("Can't seek backwards through this StreamHandle");
        }
        this.jump(pos - this.offset());
    }

    public void resetStream() throws IOException;

    default public void jump(long n) throws IOException, EOFException {
        long r;
        for (long remain = n; remain > 0L; remain -= r) {
            r = this.in().skip(remain);
            if (r >= 0L) continue;
            throw new EOFException();
        }
    }

    @Override
    default public void ensureReadable(long count) throws IOException {
        if (this.in() == null) {
            throw new IOException("This handle is write-only.");
        }
        DataHandle.super.ensureReadable(count);
    }

    @Override
    default public boolean ensureWritable(long count) throws IOException {
        if (this.out() == null) {
            throw new IOException("This handle is read-only.");
        }
        return DataHandle.super.ensureWritable(count);
    }

    @Override
    default public int read() throws IOException {
        this.ensureReadable(0L);
        int v = this.in().read();
        if (v >= 0) {
            this.advance(1L);
        }
        return v;
    }

    @Override
    default public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    default public int read(byte[] b, int off, int len) throws IOException {
        int n = this.in().read(b, off, len);
        if (n >= 0) {
            this.advance(n);
        }
        return n;
    }

    @Override
    default public void write(int v) throws IOException {
        this.ensureWritable(1L);
        this.out().write(v);
        this.advance(1L);
    }

    @Override
    default public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    default public void write(byte[] b, int off, int len) throws IOException {
        this.ensureWritable(len);
        this.out().write(b, off, len);
        this.advance(len);
    }

    @Override
    default public void close() throws IOException {
        try (InputStream in = this.in();){
            if (in != null) {
                in.close();
            }
        }
        var2_2 = null;
        try (OutputStream out = this.out();){
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }
}

