/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.scijava.Context;
import org.scijava.annotations.Index;
import org.scijava.annotations.IndexItem;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginFinder;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.SciJavaPlugin;

public class DefaultPluginFinder
implements PluginFinder {
    private final ClassLoader customClassLoader;
    private final PluginBlacklist blacklist;

    public DefaultPluginFinder() {
        this(null);
    }

    public DefaultPluginFinder(ClassLoader classLoader) {
        this.customClassLoader = classLoader;
        this.blacklist = new SysPropBlacklist();
    }

    public HashMap<String, Throwable> findPlugins(List<PluginInfo<?>> plugins) {
        HashMap<String, Throwable> exceptions = new HashMap<String, Throwable>();
        ClassLoader classLoader = this.getClassLoader();
        Index<Plugin> annotationIndex = Index.load(Plugin.class, classLoader);
        for (IndexItem<Plugin> indexItem : annotationIndex) {
            if (this.blacklist.contains(indexItem.className())) continue;
            try {
                PluginInfo<SciJavaPlugin> info = this.createInfo(indexItem, classLoader);
                plugins.add(info);
            }
            catch (Throwable t) {
                exceptions.put(indexItem.className(), t);
            }
        }
        return exceptions;
    }

    private PluginInfo<SciJavaPlugin> createInfo(IndexItem<Plugin> item, ClassLoader classLoader) {
        String className = item.className();
        Plugin plugin = item.annotation();
        Class<? extends SciJavaPlugin> pluginType = plugin.type();
        return new PluginInfo<SciJavaPlugin>(className, pluginType, plugin, classLoader);
    }

    private ClassLoader getClassLoader() {
        return this.customClassLoader != null ? this.customClassLoader : Context.getClassLoader();
    }

    private class SysPropBlacklist
    implements PluginBlacklist {
        private final List<Pattern> patterns;

        public SysPropBlacklist() {
            String sysProp = System.getProperty("scijava.plugin.blacklist");
            String[] regexes = sysProp == null ? new String[]{} : sysProp.split(":");
            this.patterns = new ArrayList<Pattern>(regexes.length);
            for (String regex : regexes) {
                try {
                    this.patterns.add(Pattern.compile(regex));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean contains(String className) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(className).matches()) continue;
                return true;
            }
            return false;
        }
    }

    private static interface PluginBlacklist {
        public boolean contains(String var1);
    }
}

