/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.log.LogService;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Plugin;
import org.scijava.script.AbstractScriptEngine;
import org.scijava.script.AbstractScriptLanguage;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptModule;
import org.scijava.script.ScriptService;
import org.scijava.test.TestUtils;
import org.scijava.util.DigestUtils;
import org.scijava.util.FileUtils;

public class ScriptInfoTest {
    private Context context;
    private ScriptService scriptService;

    @Before
    public void setUp() {
        this.context = new Context();
        this.scriptService = (ScriptService)this.context.service(ScriptService.class);
    }

    @After
    public void tearDown() {
        this.context.dispose();
    }

    @Test
    public void testGetIdentifier() {
        String name = "strategerize";
        String namedPath = "victory.bsizes";
        String named = "#@script(name = 'strategerize')\nzxywvutsrqponmlkjihgfdcba\n";
        String unnamedPath = "alphabet.bsizes";
        String unnamed = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\n0123456789\n";
        Assert.assertEquals((Object)"script:strategerize", (Object)this.id("victory.bsizes", "#@script(name = 'strategerize')\nzxywvutsrqponmlkjihgfdcba\n"));
        Assert.assertEquals((Object)"script:strategerize", (Object)this.id(null, "#@script(name = 'strategerize')\nzxywvutsrqponmlkjihgfdcba\n"));
        Assert.assertEquals((Object)"script:alphabet.bsizes", (Object)this.id("alphabet.bsizes", "ABCDEFGHIJKLMNOPQRSTUVWXYZ\n0123456789\n"));
        String hex = DigestUtils.bestHex((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ\n0123456789\n");
        Assert.assertEquals((Object)("script:<" + hex + ">"), (Object)this.id(null, "ABCDEFGHIJKLMNOPQRSTUVWXYZ\n0123456789\n"));
    }

    @Test
    public void testNewStyle() throws Exception {
        String script = "##########\n# Inputs #\n##########\n#@input int stuff\n#@input int things\n\n###########\n# Credits #\n###########\nBrought to you by:\nperson@example.com\n\n###########\n# Outputs #\n###########\n#@output String blackHoles\n#@output String revelations\n\nTHE END!\n";
        ScriptModule scriptModule = (ScriptModule)this.scriptService.run("newStyle.bsizes", "##########\n# Inputs #\n##########\n#@input int stuff\n#@input int things\n\n###########\n# Credits #\n###########\nBrought to you by:\nperson@example.com\n\n###########\n# Outputs #\n###########\n#@output String blackHoles\n#@output String revelations\n\nTHE END!\n", true, new Object[0]).get();
        String expectedProcessed = "##########\n# Inputs #\n##########\n#@input int stuff\n#@input int things\n\n###########\n# Credits #\n###########\nBrought to you by:\nperson@example.com\n\n###########\n# Outputs #\n###########\n#@output String blackHoles\n#@output String revelations\n\nTHE END!\n".replaceAll("#@.*", "");
        String actualProcessed = scriptModule.getInfo().getProcessedScript();
        Assert.assertEquals((Object)expectedProcessed, (Object)actualProcessed);
        Object output = scriptModule.getReturnValue();
        if (output == null) {
            Assert.fail((String)"null result");
        } else if (!(output instanceof Integer)) {
            Assert.fail((String)("result is a " + output.getClass().getName()));
        } else {
            Assert.assertEquals((long)4L, (long)((Integer)output).intValue());
        }
    }

    @Test
    public void testReturnValueAppended() throws Exception {
        String script = "% @LogService log\n% @int value\n";
        ScriptModule scriptModule = (ScriptModule)this.scriptService.run("include-return-value.bsizes", "% @LogService log\n% @int value\n", true, new Object[0]).get();
        Map outputs = scriptModule.getOutputs();
        Assert.assertEquals((long)1L, (long)outputs.size());
        Assert.assertTrue((boolean)outputs.containsKey("result"));
    }

    @Test
    public void testReturnValueExcluded() throws Exception {
        String script = "% @LogService log\n% @OUTPUT int value\n";
        ScriptModule scriptModule = (ScriptModule)this.scriptService.run("exclude-return-value.bsizes", "% @LogService log\n% @OUTPUT int value\n", true, new Object[0]).get();
        Map outputs = scriptModule.getOutputs();
        Assert.assertEquals((long)1L, (long)outputs.size());
        Assert.assertTrue((boolean)outputs.containsKey("value"));
        Assert.assertFalse((boolean)outputs.containsKey("result"));
    }

    @Test
    public void testNoisyParameters() throws Exception {
        String script = "% @LogService log\n% @OUTPUT Integer output% kraken@blah.net\n";
        ScriptModule scriptModule = (ScriptModule)this.scriptService.run("hello.bsizes", "% @LogService log\n% @OUTPUT Integer output% kraken@blah.net\n", true, new Object[0]).get();
        Object output = scriptModule.getReturnValue();
        if (output == null) {
            Assert.fail((String)"null result");
        } else if (!(output instanceof Integer)) {
            Assert.fail((String)("result is a " + output.getClass().getName()));
        } else {
            Assert.assertEquals((long)3L, (long)((Integer)output).intValue());
        }
    }

    @Test
    public void testVersion() throws IOException {
        String script = "% @LogService log\n% @OUTPUT int output";
        File tmpDir = TestUtils.createTemporaryDirectory((String)"script-info-test-");
        String path = "hello.bsizes";
        File scriptFile = new File(tmpDir, "hello.bsizes");
        FileUtils.writeFile((File)scriptFile, (byte[])DigestUtils.bytes((String)"% @LogService log\n% @OUTPUT int output"));
        ScriptInfo info = new ScriptInfo(this.context, scriptFile);
        String version = info.getVersion();
        String sha1 = "28f4a2880d604774ac5d604d35f431047a087c9e";
        Assert.assertTrue((boolean)version.matches("^28f4a2880d604774ac5d604d35f431047a087c9e$"));
        FileUtils.deleteRecursively((File)tmpDir);
    }

    @Test
    public void testParameters() {
        String script = "#@ LogService (required = false) log\n#@ int (label=\"Slider Value\", softMin=5, softMax=15, stepSize=3, value=11, style=\"slider\") sliderValue\n#@ String (persist = false, family='Carnivora', choices={'quick brown fox', 'lazy dog'}) animal\n#@ Double (autoFill = false) notAutoFilled\n#@ String (visibility=MESSAGE) msg\n#@BOTH java.lang.StringBuilder buffer";
        ScriptInfo info = new ScriptInfo(this.context, "params.bsizes", (Reader)new StringReader("#@ LogService (required = false) log\n#@ int (label=\"Slider Value\", softMin=5, softMax=15, stepSize=3, value=11, style=\"slider\") sliderValue\n#@ String (persist = false, family='Carnivora', choices={'quick brown fox', 'lazy dog'}) animal\n#@ Double (autoFill = false) notAutoFilled\n#@ String (visibility=MESSAGE) msg\n#@BOTH java.lang.StringBuilder buffer"));
        List noChoices = Collections.emptyList();
        ModuleItem log = info.getInput("log");
        this.assertItem("log", LogService.class, null, ItemIO.INPUT, false, true, null, null, null, null, null, null, null, null, noChoices, log);
        ModuleItem sliderValue = info.getInput("sliderValue");
        this.assertItem("sliderValue", Integer.TYPE, "Slider Value", ItemIO.INPUT, true, true, null, "slider", 11, null, null, 5, 15, 3.0, noChoices, sliderValue);
        ModuleItem animal = info.getInput("animal");
        List<String> animalChoices = Arrays.asList("quick brown fox", "lazy dog");
        this.assertItem("animal", String.class, null, ItemIO.INPUT, true, false, null, null, null, null, null, null, null, null, animalChoices, animal);
        Assert.assertEquals((Object)animal.get("family"), (Object)"Carnivora");
        ModuleItem notAutoFilled = info.getInput("notAutoFilled");
        Assert.assertFalse((boolean)notAutoFilled.isAutoFill());
        ModuleItem msg = info.getInput("msg");
        Assert.assertSame((Object)ItemVisibility.MESSAGE, (Object)msg.getVisibility());
        ModuleItem buffer = info.getOutput("buffer");
        this.assertItem("buffer", StringBuilder.class, null, ItemIO.BOTH, true, true, null, null, null, null, null, null, null, null, noChoices, buffer);
        int inputCount = 0;
        ModuleItem[] inputs = new ModuleItem[]{log, sliderValue, animal, notAutoFilled, msg, buffer};
        for (ModuleItem inItem : info.inputs()) {
            Assert.assertSame((Object)inputs[inputCount++], (Object)inItem);
        }
        int outputCount = 0;
        ModuleItem[] outputs = new ModuleItem[]{buffer};
        for (ModuleItem outItem : info.outputs()) {
            Assert.assertSame((Object)outputs[outputCount++], (Object)outItem);
        }
    }

    @Test
    public void testScriptDirective() {
        String script = "#@script(name = \"my_script\", label = \"My Script\", description = \"What a great script.\", menuPath = \"Plugins > Do All The Things\", menuRoot = \"special\", iconPath = \"/path/to/myIcon.png\", priority = \"extremely-high\", headless = true, foo = \"bar\")\nWOOT\n";
        ScriptInfo info = null;
        info = new ScriptInfo(this.context, "scriptHeader.bsizes", (Reader)new StringReader("#@script(name = \"my_script\", label = \"My Script\", description = \"What a great script.\", menuPath = \"Plugins > Do All The Things\", menuRoot = \"special\", iconPath = \"/path/to/myIcon.png\", priority = \"extremely-high\", headless = true, foo = \"bar\")\nWOOT\n"));
        info.inputs();
        Assert.assertEquals((Object)"my_script", (Object)info.getName());
        Assert.assertEquals((Object)"My Script", (Object)info.getLabel());
        Assert.assertEquals((Object)"What a great script.", (Object)info.getDescription());
        MenuPath menuPath = info.getMenuPath();
        Assert.assertEquals((long)2L, (long)menuPath.size());
        Assert.assertEquals((Object)"Plugins", (Object)((MenuEntry)menuPath.get(0)).getName());
        Assert.assertEquals((Object)"Do All The Things", (Object)((MenuEntry)menuPath.get(1)).getName());
        Assert.assertEquals((Object)"/path/to/myIcon.png", (Object)info.getIconPath());
        Assert.assertEquals((double)1000000.0, (double)info.getPriority(), (double)0.0);
        Assert.assertTrue((boolean)info.canRunHeadless());
        Assert.assertEquals((Object)"bar", (Object)info.get("foo"));
    }

    @Test
    public void testReaderSanity() throws Exception {
        String script = "% @LogService log\n% @OUTPUT Integer output";
        ScriptInfo info = new ScriptInfo(this.context, "hello.bsizes", (Reader)new StringReader("% @LogService log\n% @OUTPUT Integer output"));
        BufferedReader reader1 = info.getReader();
        BufferedReader reader2 = info.getReader();
        Assert.assertEquals((String)"Readers are not independent.", (long)reader1.read(), (long)reader2.read());
    }

    private String id(String path, String script) {
        ScriptInfo info = new ScriptInfo(this.context, path, (Reader)new StringReader(script));
        info.inputs();
        return info.getIdentifier();
    }

    private void assertItem(String name, Class<?> type, String label, ItemIO ioType, boolean required, boolean persist, String persistKey, String style, Object value, Object min, Object max, Object softMin, Object softMax, Number stepSize, List<?> choices, ModuleItem<?> item) {
        Assert.assertEquals((Object)name, (Object)item.getName());
        Assert.assertSame(type, (Object)item.getType());
        Assert.assertEquals((Object)label, (Object)item.getLabel());
        Assert.assertSame((Object)ioType, (Object)item.getIOType());
        Assert.assertEquals((Object)required, (Object)item.isRequired());
        Assert.assertEquals((Object)persist, (Object)item.isPersisted());
        Assert.assertEquals((Object)persistKey, (Object)item.getPersistKey());
        Assert.assertEquals((Object)style, (Object)item.getWidgetStyle());
        Assert.assertEquals((Object)value, (Object)item.getDefaultValue());
        Assert.assertEquals((Object)min, (Object)item.getMinimumValue());
        Assert.assertEquals((Object)max, (Object)item.getMaximumValue());
        Assert.assertEquals((Object)softMin, (Object)item.getSoftMinimum());
        Assert.assertEquals((Object)softMax, (Object)item.getSoftMaximum());
        Assert.assertEquals((Object)stepSize, (Object)item.getStepSize());
        Assert.assertEquals(choices, (Object)item.getChoices());
    }

    private static class BindingSizesBindings
    extends HashMap<String, Object>
    implements Bindings {
        private BindingSizesBindings() {
        }
    }

    private static class BindingSizesEngine
    extends AbstractScriptEngine {
        private BindingSizesEngine() {
            this.engineScopeBindings = new BindingSizesBindings();
        }

        public Object eval(String script) throws ScriptException {
            return this.eval(new StringReader(script));
        }

        public Object eval(Reader reader) throws ScriptException {
            Bindings bindings = this.getBindings(100);
            return bindings.size();
        }
    }

    @Plugin(type=ScriptLanguage.class)
    public static class BindingSizes
    extends AbstractScriptLanguage {
        public ScriptEngine getScriptEngine() {
            return new BindingSizesEngine();
        }

        public List<String> getNames() {
            return Arrays.asList("BindingSizes");
        }

        public List<String> getExtensions() {
            return Arrays.asList("bsizes");
        }
    }
}

