/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command;

import java.util.Arrays;
import java.util.Iterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.command.Command;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandService;
import org.scijava.log.LogService;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public class CommandInfoTest {
    private Context ctx;
    private CommandService commandService;

    @Before
    public void setUp() {
        this.ctx = new Context(new Class[]{CommandService.class});
        this.commandService = (CommandService)this.ctx.getService(CommandService.class);
    }

    @After
    public void tearDown() {
        this.ctx.dispose();
    }

    @Test
    public void testEnumParam() {
        CommandInfo info = this.commandService.getCommand(CommandWithEnumParam.class);
        Assert.assertNotNull((Object)info);
        Iterator iter = info.inputs().iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        ModuleItem freeform = (ModuleItem)iter.next();
        Assert.assertTrue((boolean)iter.hasNext());
        ModuleItem constrained = (ModuleItem)iter.next();
        Assert.assertTrue((boolean)iter.hasNext());
        ModuleItem choice = (ModuleItem)iter.next();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertSame(String.class, (Object)freeform.getType());
        Assert.assertNull((Object)freeform.getChoices());
        Assert.assertSame(String.class, (Object)constrained.getType());
        Assert.assertEquals(Arrays.asList("foo", "bar", "fubar"), (Object)constrained.getChoices());
        Assert.assertSame(CommandWithEnumParam.Choice.class, (Object)choice.getType());
        Assert.assertEquals(Arrays.asList(CommandWithEnumParam.Choice.YES, CommandWithEnumParam.Choice.NO, CommandWithEnumParam.Choice.MAYBE_SO), (Object)choice.getChoices());
    }

    @Test
    public void testDuplicateServiceParameters() {
        CommandInfo commandInfo = new CommandInfo(ExtendedServiceCommand.class);
        Assert.assertTrue((boolean)commandInfo.isValid());
    }

    private static class ExtendedServiceCommand
    extends ServiceCommand {
        @Parameter
        private LogService logService;

        private ExtendedServiceCommand() {
        }

        @Override
        public void run() {
        }
    }

    private static class ServiceCommand
    implements Command {
        @Parameter
        private LogService logService;

        private ServiceCommand() {
        }

        public void run() {
        }
    }

    @Plugin(type=Command.class)
    public static class CommandWithEnumParam
    implements Command {
        @Parameter
        private String freeform;
        @Parameter(choices={"foo", "bar", "fubar"})
        private String constrained;
        @Parameter
        private Choice choice;

        public void run() {
        }

        public static enum Choice {
            YES,
            NO,
            MAYBE_SO;

        }
    }
}

