/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.module.AbstractModule;
import org.scijava.module.AbstractModuleInfo;
import org.scijava.module.AbstractModuleItem;
import org.scijava.module.DefaultMutableModule;
import org.scijava.module.DefaultMutableModuleItem;
import org.scijava.module.Module;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;
import org.scijava.parse.ParseService;

public class ModuleServiceTest {
    private ModuleService moduleService;

    @Before
    public void setUp() {
        Context context = new Context(new Class[]{ModuleService.class, ParseService.class});
        this.moduleService = (ModuleService)context.service(ModuleService.class);
    }

    @After
    public void tearDown() {
        this.moduleService.context().dispose();
    }

    @Test
    public void testRunModuleInfoArray() throws InterruptedException, ExecutionException {
        FooModuleInfo info = new FooModuleInfo();
        Module m = (Module)this.moduleService.run((ModuleInfo)info, false, this.createInputArray()).get();
        Assert.assertEquals((Object)this.expectedResult(), (Object)m.getOutput("result"));
    }

    @Test
    public void testRunModuleInfoMap() throws InterruptedException, ExecutionException {
        FooModuleInfo info = new FooModuleInfo();
        Module m = (Module)this.moduleService.run((ModuleInfo)info, false, this.createInputMap()).get();
        Assert.assertEquals((Object)this.expectedResult(), (Object)m.getOutput("result"));
    }

    @Test
    public void testRunModuleArray() throws ModuleException, InterruptedException, ExecutionException {
        FooModuleInfo info = new FooModuleInfo();
        Module module = info.createModule();
        Module m = (Module)this.moduleService.run(module, false, this.createInputArray()).get();
        Assert.assertSame((Object)module, (Object)m);
        Assert.assertEquals((Object)this.expectedResult(), (Object)m.getOutput("result"));
    }

    @Test
    public void testRunModuleMap() throws ModuleException, InterruptedException, ExecutionException {
        FooModuleInfo info = new FooModuleInfo();
        Module module = info.createModule();
        Module m = (Module)this.moduleService.run(module, false, this.createInputMap()).get();
        Assert.assertSame((Object)module, (Object)m);
        Assert.assertEquals((Object)this.expectedResult(), (Object)m.getOutput("result"));
    }

    @Test
    public void testRunMapHack() throws ModuleException, InterruptedException, ExecutionException {
        FooModuleInfo info = new FooModuleInfo();
        Object[] inputs = new Object[]{this.createInputMap()};
        Module m = (Module)this.moduleService.run((ModuleInfo)info, false, inputs).get();
        Assert.assertEquals((Object)this.expectedResult(), (Object)m.getOutput("result"));
        Module module = info.createModule();
        Module m2 = (Module)this.moduleService.run(module, false, inputs).get();
        Assert.assertEquals((Object)this.expectedResult(), (Object)m2.getOutput("result"));
    }

    @Test
    public void testGetSingleInput() throws ModuleException {
        FooModuleInfo info = new FooModuleInfo();
        Module module = info.createModule();
        ModuleItem singleString = this.moduleService.getSingleInput(module, String.class);
        Assert.assertSame((Object)info.getInput("string"), (Object)singleString);
        ModuleItem singleFloat = this.moduleService.getSingleInput(module, Float.class);
        Assert.assertNull((Object)singleFloat);
        ModuleItem singleInteger = this.moduleService.getSingleInput(module, Integer.class);
        Assert.assertNull((Object)singleInteger);
        ModuleItem singleDouble = this.moduleService.getSingleInput(module, Double.class);
        Assert.assertSame((Object)info.getInput("double2"), (Object)singleDouble);
    }

    @Test
    public void testSaveAndLoad() {
        List<Object> objects = Arrays.asList(new double[0], new double[]{1.0, 2.0, 3.0}, new Double[0], new Double[]{1.0, 2.0, 3.0});
        objects.forEach(this::assertParamSavedAndLoaded);
    }

    private <T> void assertParamSavedAndLoaded(T object) {
        Class<?> c = object.getClass();
        DefaultMutableModule m = new DefaultMutableModule();
        m.getInfo().addInput((ModuleItem)new DefaultMutableModuleItem((Module)m, "a", c));
        ModuleItem item = this.moduleService.getSingleInput((Module)m, c);
        this.moduleService.save(item, object);
        Object actual = this.moduleService.load(item);
        if (object.getClass().isArray()) {
            this.assertArrayEquality(object, actual);
        } else {
            Assert.assertEquals(object, (Object)actual);
        }
    }

    private void assertArrayEquality(Object arr1, Object arr2) {
        Assert.assertEquals(arr1.getClass(), arr2.getClass());
        Assert.assertTrue((boolean)arr1.getClass().isArray());
        if (arr1 instanceof boolean[]) {
            Assert.assertArrayEquals((boolean[])((boolean[])arr1), (boolean[])((boolean[])arr2));
        } else if (arr1 instanceof byte[]) {
            Assert.assertArrayEquals((byte[])((byte[])arr1), (byte[])((byte[])arr2));
        } else if (arr1 instanceof short[]) {
            Assert.assertArrayEquals((short[])((short[])arr1), (short[])((short[])arr2));
        } else if (arr1 instanceof int[]) {
            Assert.assertArrayEquals((int[])((int[])arr1), (int[])((int[])arr2));
        } else if (arr1 instanceof long[]) {
            Assert.assertArrayEquals((long[])((long[])arr1), (long[])((long[])arr2));
        } else if (arr1 instanceof float[]) {
            Assert.assertArrayEquals((float[])((float[])arr1), (float[])((float[])arr2), (float)1.0E-6f);
        } else if (arr1 instanceof double[]) {
            Assert.assertArrayEquals((double[])((double[])arr1), (double[])((double[])arr2), (double)1.0E-6);
        } else if (arr1 instanceof char[]) {
            Assert.assertArrayEquals((char[])((char[])arr1), (char[])((char[])arr2));
        } else {
            Assert.assertArrayEquals((Object[])((Object[])arr1), (Object[])((Object[])arr2));
        }
    }

    private Object[] createInputArray() {
        return new Object[]{"string", "hello", "float", Float.valueOf(1.234f), "integer1", -2, "integer2", 7, "double1", Math.E, "double2", Math.PI};
    }

    private Map<String, Object> createInputMap() {
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        inputMap.put("string", "hello");
        inputMap.put("float", Float.valueOf(1.234f));
        inputMap.put("integer1", -2);
        inputMap.put("integer2", 7);
        inputMap.put("double1", Math.E);
        inputMap.put("double2", Math.PI);
        return inputMap;
    }

    private String expectedResult() {
        return ModuleServiceTest.mapToString(this.createInputMap());
    }

    private static String mapToString(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append(entry.getKey() + " = " + entry.getValue() + "\n");
        }
        return sb.toString();
    }

    public static class FooModuleInfo
    extends AbstractModuleInfo {
        public String getDelegateClassName() {
            return FooModule.class.getName();
        }

        public Class<?> loadDelegateClass() throws ClassNotFoundException {
            return FooModule.class;
        }

        public Module createModule() throws ModuleException {
            return new FooModule(this);
        }

        protected void parseParameters() {
            this.addInput("string", String.class, true);
            this.addInput("float", Float.class, false);
            this.addInput("integer1", Integer.class, true);
            this.addInput("integer2", Integer.class, true);
            this.addInput("double1", Double.class, false);
            this.addInput("double2", Double.class, true);
            this.addOutput("result", String.class);
        }

        private <T> void addInput(final String name, final Class<T> type, final boolean autoFill) {
            this.registerInput((ModuleItem)new AbstractModuleItem<T>((ModuleInfo)this){

                public String getName() {
                    return name;
                }

                public Class<T> getType() {
                    return type;
                }

                public boolean isAutoFill() {
                    return autoFill;
                }
            });
        }

        private <T> void addOutput(final String name, final Class<T> type) {
            this.registerOutput((ModuleItem)new AbstractModuleItem<T>((ModuleInfo)this){

                public String getName() {
                    return name;
                }

                public Class<T> getType() {
                    return type;
                }
            });
        }
    }

    public static class FooModule
    extends AbstractModule {
        private final FooModuleInfo info;

        public FooModule(FooModuleInfo info) {
            this.info = info;
        }

        public ModuleInfo getInfo() {
            return this.info;
        }

        public void run() {
            this.setOutput("result", ModuleServiceTest.mapToString(this.getInputs()));
        }
    }
}

