/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.prefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.prefs.AbstractPrefService;
import org.scijava.prefs.PrefService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultPrefService
extends AbstractPrefService {
    @Parameter(required=false)
    private LogService log;

    @Override
    public String get(Class<?> c, String name, String defaultValue) {
        return this.prefs(c).get(name, defaultValue);
    }

    @Override
    public boolean getBoolean(Class<?> c, String name, boolean defaultValue) {
        return this.prefs(c).getBoolean(name, defaultValue);
    }

    @Override
    public double getDouble(Class<?> c, String name, double defaultValue) {
        return this.prefs(c).getDouble(name, defaultValue);
    }

    @Override
    public float getFloat(Class<?> c, String name, float defaultValue) {
        return this.prefs(c).getFloat(name, defaultValue);
    }

    @Override
    public int getInt(Class<?> c, String name, int defaultValue) {
        return this.prefs(c).getInt(name, defaultValue);
    }

    @Override
    public long getLong(Class<?> c, String name, long defaultValue) {
        return this.prefs(c).getLong(name, defaultValue);
    }

    @Override
    public Map<String, String> getMap(Class<?> c, String name) {
        return this.prefs(c).node(name).getMap();
    }

    @Override
    public List<String> getList(Class<?> c, String name) {
        return this.prefs(c).node(name).getList();
    }

    @Override
    public void put(Class<?> c, String name, String value) {
        this.prefs(c).put(name, value);
    }

    @Override
    public void put(Class<?> c, String name, boolean value) {
        this.prefs(c).putBoolean(name, value);
    }

    @Override
    public void put(Class<?> c, String name, double value) {
        this.prefs(c).putDouble(name, value);
    }

    @Override
    public void put(Class<?> c, String name, float value) {
        this.prefs(c).putFloat(name, value);
    }

    @Override
    public void put(Class<?> c, String name, int value) {
        this.prefs(c).putInt(name, value);
    }

    @Override
    public void put(Class<?> c, String name, long value) {
        this.prefs(c).putLong(name, value);
    }

    @Override
    public void put(Class<?> c, String name, Map<String, String> value) {
        this.prefs(c).node(name).putMap(value);
    }

    @Override
    public void put(Class<?> c, String name, Iterable<String> value) {
        this.prefs(c).node(name).putList(value);
    }

    @Override
    public void remove(Class<?> c, String name) {
        this.prefs(c).remove(name);
    }

    @Override
    public void clear(Class<?> c) {
        this.prefs(c).removeNode();
    }

    @Override
    public void clearAll() {
        for (String name : this.allPrefs()) {
            this.prefs(name).removeNode();
        }
    }

    @Override
    @Deprecated
    public void putMap(Class<?> c, Map<String, String> map) {
        this.prefs(c).putMap(map);
    }

    @Override
    @Deprecated
    public Map<String, String> getMap(Class<?> c) {
        return this.prefs(c).getMap();
    }

    @Override
    @Deprecated
    public void putList(Class<?> c, List<String> list) {
        this.prefs(c).putList(list);
    }

    @Override
    @Deprecated
    public List<String> getList(Class<?> c) {
        return this.prefs(c).getList();
    }

    @Override
    @Deprecated
    public Iterable<String> getIterable(Class<?> c, String name) {
        return this.prefs(c).node(name).getIterable();
    }

    @Override
    @Deprecated
    public void clear(String absolutePath, String key) {
        this.prefs(absolutePath).clear(key);
    }

    @Override
    @Deprecated
    public void remove(String absolutePath, String key) {
        this.prefs(absolutePath).remove(key);
    }

    @Override
    @Deprecated
    public void putMap(String absolutePath, Map<String, String> map, String key) {
        this.prefs(absolutePath).node(key).putMap(map);
    }

    @Override
    @Deprecated
    public void putMap(String absolutePath, Map<String, String> map) {
        this.prefs(absolutePath).putMap(map);
    }

    @Override
    @Deprecated
    public Map<String, String> getMap(String absolutePath, String key) {
        return this.prefs(absolutePath).node(key).getMap();
    }

    @Override
    @Deprecated
    public void putList(String absolutePath, List<String> list, String key) {
        this.prefs(absolutePath).node(key).putList(list);
    }

    @Override
    @Deprecated
    public void putList(String absolutePath, List<String> list) {
        this.prefs(absolutePath).putList(list);
    }

    @Override
    @Deprecated
    public List<String> getList(String absolutePath, String key) {
        return this.prefs(absolutePath).node(key).getList();
    }

    @Override
    @Deprecated
    public void clear(Class<?> c, String name) {
        this.prefs(c).clear(name);
    }

    private SmartPrefs prefs(Class<?> c) {
        Class nodeClass = c == null ? PrefService.class : c;
        return new SmartPrefs(Preferences.userNodeForPackage(nodeClass).node(nodeClass.getSimpleName()), this.log);
    }

    private SmartPrefs prefs(String absolutePath) {
        return new SmartPrefs(Preferences.userRoot().node(absolutePath), this.log);
    }

    private String[] allPrefs() {
        try {
            return Preferences.userRoot().childrenNames();
        }
        catch (BackingStoreException exc) {
            if (this.log != null) {
                this.log.error(exc);
            }
            return new String[0];
        }
    }

    private static class SmartPrefs {
        private final Preferences p;
        private final LogService log;

        public SmartPrefs(Preferences p, LogService log) {
            this.p = p;
            this.log = log;
        }

        public void remove(String key) {
            if (this.nodeExists(key)) {
                this.node(key).removeNode();
            }
            this.p.remove(this.safeKey(key));
        }

        public void putMap(Map<String, String> map) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue();
                this.put(key, value);
            }
        }

        public Map<String, String> getMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            String[] keys = this.keys();
            for (int index = 0; index < keys.length; ++index) {
                map.put(keys[index], this.get(keys[index]));
            }
            return map;
        }

        public void putList(Iterable<String> list) {
            int index = 0;
            for (String value : list) {
                this.put("" + index++, value);
            }
        }

        public List<String> getList() {
            String value;
            ArrayList<String> list = new ArrayList<String>();
            for (int index = 0; index < Integer.MAX_VALUE && (value = this.get("" + index)) != null; ++index) {
                list.add(value);
            }
            return list;
        }

        public Iterable<String> getIterable() {
            return new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        private String value;
                        private int index;
                        {
                            this.findNext();
                        }

                        @Override
                        public String next() {
                            String result = this.value;
                            this.findNext();
                            return result;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.value != null;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        private void findNext() {
                            if (this.index < 0) {
                                return;
                            }
                            this.value = this.get("" + this.index);
                            this.index = this.value == null ? -1 : this.index + 1;
                        }
                    };
                }
            };
        }

        public void put(String key, Object value) {
            this.p.put(this.safeKey(key), this.safeValue(value));
        }

        public String get(String key) {
            return this.get(key, null);
        }

        public String get(String key, String def) {
            return this.p.get(this.safeKey(key), def);
        }

        public void clear() {
            block2: {
                try {
                    this.p.clear();
                }
                catch (BackingStoreException exc) {
                    if (this.log == null) break block2;
                    this.log.error(exc);
                }
            }
        }

        public void putInt(String key, int value) {
            this.p.putInt(this.safeKey(key), value);
        }

        public int getInt(String key, int def) {
            return this.p.getInt(this.safeKey(key), def);
        }

        public void putLong(String key, long value) {
            this.p.putLong(this.safeKey(key), value);
        }

        public long getLong(String key, long def) {
            return this.p.getLong(this.safeKey(key), def);
        }

        public void putBoolean(String key, boolean value) {
            this.p.putBoolean(this.safeKey(key), value);
        }

        public boolean getBoolean(String key, boolean def) {
            return this.p.getBoolean(this.safeKey(key), def);
        }

        public void putFloat(String key, float value) {
            this.p.putFloat(this.safeKey(key), value);
        }

        public float getFloat(String key, float def) {
            return this.p.getFloat(this.safeKey(key), def);
        }

        public void putDouble(String key, double value) {
            this.p.putDouble(this.safeKey(key), value);
        }

        public double getDouble(String key, double def) {
            return this.p.getDouble(this.safeKey(key), def);
        }

        public String[] keys() {
            try {
                String[] keys = this.p.keys();
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = this.safeKey(keys[i]);
                }
                return keys;
            }
            catch (BackingStoreException exc) {
                if (this.log != null) {
                    this.log.error(exc);
                }
                return new String[0];
            }
        }

        public SmartPrefs node(String pathName) {
            return new SmartPrefs(this.p.node(this.safeName(pathName)), this.log);
        }

        public boolean nodeExists(String pathName) {
            try {
                return this.p.nodeExists(this.safeName(pathName));
            }
            catch (BackingStoreException exc) {
                if (this.log != null) {
                    this.log.error(exc);
                }
                return false;
            }
        }

        public void removeNode() {
            block2: {
                try {
                    this.p.removeNode();
                }
                catch (BackingStoreException exc) {
                    if (this.log == null) break block2;
                    this.log.error(exc);
                }
            }
        }

        private String safeKey(String key) {
            return this.makeSafe(key, 80);
        }

        private String safeValue(Object value) {
            if (value == null) {
                return null;
            }
            return this.makeSafe(value.toString(), 8192);
        }

        private String safeName(String name) {
            return this.makeSafe(name, 80);
        }

        private String makeSafe(String s, int max) {
            if (s == null) {
                return "";
            }
            int len = s.length();
            if (len < max) {
                return s;
            }
            return "..." + s.substring(len - max + 3, len);
        }

        @Deprecated
        public void clear(String key) {
            if (this.nodeExists(key)) {
                this.node(key).clear();
            }
        }
    }
}

