/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.scijava.Context;
import org.scijava.plugin.PluginInfo;
import org.scijava.script.AbstractScriptLanguage;

public class AdaptedScriptLanguage
extends AbstractScriptLanguage {
    private final ScriptEngineFactory base;

    public AdaptedScriptLanguage(ScriptEngineFactory base) {
        if (base == null) {
            throw new NullPointerException();
        }
        this.base = base;
    }

    public AdaptedScriptLanguage(String factoryName) {
        this(AdaptedScriptLanguage.findFactory(factoryName));
    }

    @Override
    public String getEngineName() {
        return this.base.getEngineName();
    }

    @Override
    public String getEngineVersion() {
        return this.base.getEngineVersion();
    }

    @Override
    public List<String> getExtensions() {
        return this.base.getExtensions();
    }

    @Override
    public List<String> getMimeTypes() {
        return this.base.getMimeTypes();
    }

    @Override
    public List<String> getNames() {
        return this.base.getNames();
    }

    @Override
    public String getLanguageName() {
        PluginInfo<?> info = this.getInfo();
        String name = info == null ? null : info.getName();
        return name != null && !name.isEmpty() ? name : this.base.getLanguageName();
    }

    @Override
    public String getLanguageVersion() {
        return this.base.getLanguageVersion();
    }

    @Override
    public Object getParameter(String key) {
        return this.base.getParameter(key);
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        return this.base.getMethodCallSyntax(obj, m, args);
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return this.base.getOutputStatement(toDisplay);
    }

    @Override
    public String getProgram(String ... statements) {
        return this.base.getProgram(statements);
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return this.base.getScriptEngine();
    }

    private static ScriptEngineFactory findFactory(String factoryName) {
        ScriptEngineManager manager = new ScriptEngineManager(Context.getClassLoader());
        for (ScriptEngineFactory factory : manager.getEngineFactories()) {
            for (String name : factory.getNames()) {
                if (!factoryName.equals(name)) continue;
                return factory;
            }
        }
        throw new IllegalArgumentException("No such script engine: " + factoryName);
    }
}

