/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.run.console;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import org.scijava.console.AbstractConsoleArgument;
import org.scijava.console.ConsoleArgument;
import org.scijava.log.LogService;
import org.scijava.parse.Items;
import org.scijava.parse.ParseService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.run.RunService;
import org.scijava.startup.StartupService;

@Plugin(type=ConsoleArgument.class)
public class RunArgument
extends AbstractConsoleArgument {
    @Parameter
    private RunService runService;
    @Parameter
    private StartupService startupService;
    @Parameter
    private ParseService parser;
    @Parameter
    private LogService log;

    public RunArgument() {
        super(2, "--run");
    }

    @Override
    public void handle(LinkedList<String> args) {
        if (!this.supports(args)) {
            return;
        }
        args.removeFirst();
        String code = args.removeFirst();
        String arg = this.getParam(args);
        if (arg != null) {
            args.removeFirst();
        }
        this.startupService.addOperation(() -> {
            block5: {
                try {
                    if (arg == null) {
                        this.runService.run((Object)code, new Object[0]);
                        break block5;
                    }
                    Items items = this.parser.parse(arg);
                    if (items.isMap()) {
                        this.runService.run((Object)code, items.asMap());
                        break block5;
                    }
                    if (items.isList()) {
                        this.runService.run((Object)code, items.toArray());
                        break block5;
                    }
                    throw new IllegalArgumentException("Arguments are inconsistent. Please pass either a list of key/value pairs, or a list of values.");
                }
                catch (InvocationTargetException exc) {
                    throw new RuntimeException(exc);
                }
            }
        });
    }

    @Override
    public boolean supports(LinkedList<String> args) {
        if (!super.supports(args)) {
            return false;
        }
        return this.runService.supports(args.get(1));
    }
}

