/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.concurrent;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.scijava.concurrent.Parallelization;
import org.scijava.concurrent.TaskExecutor;

public class ParallelizationDemo {
    public static void main(String ... args) {
        System.out.println("\nSingle Threaded:\n================");
        Parallelization.runSingleThreaded(() -> ParallelizationDemo.exampleAlgorithm());
        System.out.println("\nMulti Threaded:\n===============");
        Parallelization.runMultiThreaded(() -> ParallelizationDemo.exampleAlgorithm());
        System.out.println("\nTwo Threads:\n===============");
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Parallelization.runWithExecutor((ExecutorService)executor, () -> ParallelizationDemo.exampleAlgorithm());
        executor.shutdown();
    }

    private static void exampleAlgorithm() {
        TaskExecutor taskExecutor = Parallelization.getTaskExecutor();
        System.out.println("Parallelism Level: " + taskExecutor.getParallelism());
        List<Integer> list = Arrays.asList(1, 2, 3, 4);
        taskExecutor.forEach(list, index -> {
            System.out.println("task " + index + " start");
            ParallelizationDemo.waitOneSecond();
            System.out.println("task " + index + " finish");
        });
    }

    private static void waitOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

