/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.concurrent.TaskExecutor;
import org.scijava.concurrent.TaskExecutors;

public class TaskExecutorsTest {
    @Test
    public void testSingleThreaded() {
        TaskExecutor executor = TaskExecutors.singleThreaded();
        Assertions.assertInstanceOf(TaskExecutors.SequentialTaskExecutor.class, (Object)executor);
    }

    @Test
    public void testMultiThreaded() {
        TaskExecutor executor = TaskExecutors.multiThreaded();
        Assertions.assertInstanceOf(TaskExecutors.ForkJoinExecutorService.class, (Object)executor.getExecutorService());
    }

    @Test
    public void testNumThreads() {
        TaskExecutor executor = TaskExecutors.numThreads((int)2);
        Assertions.assertEquals((int)2, (int)executor.getParallelism());
        executor.getExecutorService().shutdown();
    }

    @Test
    public void testForExecutorService() {
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        TaskExecutor executor = TaskExecutors.forExecutorService((ExecutorService)executorService);
        Assertions.assertEquals((Object)executorService, (Object)executor.getExecutorService());
        executorService.shutdown();
    }

    @Test
    public void testForExecutorServiceAndNumThreads() {
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        TaskExecutor executor = TaskExecutors.forExecutorServiceAndNumThreads((ExecutorService)executorService, (int)42);
        Assertions.assertEquals((Object)executorService, (Object)executor.getExecutorService());
        Assertions.assertEquals((int)42, (int)executor.getParallelism());
        executorService.shutdown();
    }

    @Test
    public void testForExecutorServiceAndNumTasks() {
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        TaskExecutor executor = TaskExecutors.forExecutorServiceAndNumTasks((ExecutorService)executorService, (int)42);
        Assertions.assertEquals((Object)executorService, (Object)executor.getExecutorService());
        Assertions.assertEquals((int)2, (int)executor.getParallelism());
        Assertions.assertEquals((int)42, (int)executor.suggestNumberOfTasks());
    }
}

