/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.scijava.discovery.Discoverer;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.spi.Op;
import org.scijava.ops.spi.OpCollection;

public abstract class AbstractTestEnvironment {
    protected static OpEnvironment ops;

    @BeforeAll
    public static void setUp() {
        ops = AbstractTestEnvironment.barebonesEnvironment();
    }

    @AfterAll
    public static void tearDown() {
        ops = null;
    }

    protected static <T> Optional<T> objFromNoArgConstructor(Class<T> c) {
        try {
            return Optional.of(c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    protected static Object[] objsFromNoArgConstructors(Class<?>[] arr) {
        return Arrays.stream(arr).map(AbstractTestEnvironment::objFromNoArgConstructor).filter(Optional::isPresent).map(Optional::get).toArray();
    }

    protected static OpEnvironment barebonesEnvironment() {
        Discoverer serviceLoading = Discoverer.using(ServiceLoader::load).except(new Class[]{Op.class, OpInfo.class, OpCollection.class});
        OpEnvironment ops = OpEnvironment.buildEmpty();
        ops.discoverUsing(new Discoverer[]{serviceLoading});
        return ops;
    }

    protected static boolean arrayEquals(double[] arr1, Double ... arr2) {
        return Arrays.deepEquals(Arrays.stream(arr1).boxed().toArray(Double[]::new), arr2);
    }

    protected static <T> void assertIterationsEqual(Iterable<T> expected, Iterable<T> actual) {
        Iterator<T> e = expected.iterator();
        Iterator<T> a = actual.iterator();
        while (e.hasNext()) {
            Assertions.assertTrue((boolean)a.hasNext(), (String)"Fewer elements than expected");
            Assertions.assertEquals(e.next(), a.next());
        }
        Assertions.assertFalse((boolean)a.hasNext(), (String)"More elements than expected");
    }
}

