/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.types.Nil;

public class OpBuilderNoOutputTest<T extends Number>
extends AbstractTestEnvironment
implements OpCollection {
    public final String opName = "test.noOutput";
    @OpField(names="test.noOutput")
    public final Function<T, WrappedList<T>> func = in -> {
        WrappedList<Number> out = new WrappedList<Number>();
        out.add((Number)in);
        return out;
    };

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new OpBuilderNoOutputTest()});
    }

    @Test
    public void testNoParameterizedTypeOutputGiven() {
        Object output = ops.op("test.noOutput").input((Object)5.0).apply();
        Type expectedOutputType = new Nil<WrappedList<Double>>(){}.type();
        Assertions.assertEquals((Object)ops.genericType(output), (Object)expectedOutputType);
    }

    private static class WrappedList<E>
    extends ArrayList<E> {
        private WrappedList() {
        }
    }
}

