/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine;

import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.SuperOpMethodHousingClass;
import org.scijava.ops.engine.SuperOpMethodHousingInterface;
import org.scijava.types.Nil;

public class OpMethodInParentTest
extends AbstractTestEnvironment {
    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new SuperOpMethodHousingClass()});
        ops.register(new Object[]{new SuperOpMethodHousingInterface()});
    }

    @Test
    public void testFMethodInSuperclass() {
        String actual = (String)ops.op("test.superMethod").input((Object)"Foo").outType(String.class).apply();
        String expected = "This string came from " + SuperOpMethodHousingClass.class;
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFMethodInInterface() {
        String actual = (String)ops.op("test.superMethodIface").input((Object)"Foo").outType(String.class).apply();
        String expected = "This string came from " + SuperOpMethodHousingInterface.class;
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRequestingFunctionalTypeSubclass() {
        Function function = (Function)ops.op("test.superMethod", (Nil)new Nil<Function<String, String>>(){}, new Nil[]{new Nil<String>(){}}, (Nil)new Nil<String>(){});
        Assertions.assertThrows(ClassCastException.class, () -> {
            SuperOpMethodHousingClass op = (SuperOpMethodHousingClass)ops.op("test.superMethod", (Nil)new Nil<SuperOpMethodHousingClass>(){}, new Nil[]{new Nil<String>(){}}, (Nil)new Nil<String>(){});
        });
    }
}

