/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.collections.ObjectArray;
import org.scijava.function.Computers;
import org.scijava.function.Producer;
import org.scijava.ops.api.InfoTree;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.Ops;
import org.scijava.ops.api.RichOp;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.adapt.functional.ComputersToFunctionsViaFunction;
import org.scijava.ops.engine.adapt.lift.FunctionToArrays;
import org.scijava.ops.engine.conversionLoss.impl.PrimitiveLossReporters;
import org.scijava.ops.engine.copy.CopyOpCollection;
import org.scijava.ops.engine.create.CreateOpCollection;
import org.scijava.ops.engine.matcher.convert.IdentityCollection;
import org.scijava.ops.engine.matcher.convert.PrimitiveArrayConverters;
import org.scijava.ops.engine.matcher.convert.UtilityConverters;
import org.scijava.ops.spi.Op;
import org.scijava.ops.spi.OpClass;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpDependency;
import org.scijava.ops.spi.OpField;
import org.scijava.types.Nil;

public class ProvenanceTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.provenance")
    public final Producer<String> foo = () -> "provenance";
    @OpField(names="test.provenanceComputer")
    public final Computers.Arity1<Double[], Double[]> op = (in, out) -> {
        for (int i = 0; i < ((Double[])in).length && i < ((Double[])out).length; ++i) {
            out[i] = in[i];
        }
    };
    @OpField(names="test.provenance")
    public final Function<List<? extends Number>, Double> bar = l -> l.stream().map(Number::doubleValue).reduce(Double::sum).orElse(0.0);
    @OpField(names="test.provenance", priority=100.0)
    public final Function<List<Double>, Double> baz = l -> l.stream().reduce(Double::sum).orElse(0.0);
    @OpField(names="test.provenanceMapped")
    public final Function<Double, Thing> mappedFunc = Thing::new;

    @BeforeAll
    public static void AddNeededOps() {
        ops.register(new Object[]{new ProvenanceTest()});
        ops.register(new Object[]{new MapperFunc()});
        ops.register(new Object[]{new FunctionToArrays()});
        ops.register(new Object[]{new IdentityCollection()});
        ops.register(new Object[]{new UtilityConverters()});
        ops.register(new Object[]{new PrimitiveArrayConverters()});
        ops.register(new Object[]{new PrimitiveLossReporters()});
        ops.register(new Object[]{new CopyOpCollection()});
        ops.register(new Object[]{new CreateOpCollection()});
        Object[] adaptors = ProvenanceTest.objsFromNoArgConstructors(ComputersToFunctionsViaFunction.class.getDeclaredClasses());
        ops.register(adaptors);
    }

    @Test
    public void testProvenance() {
        String s = (String)ops.op("test.provenance").outType(String.class).create();
        List executionsUpon = ops.history().executionsUpon((Object)s);
        Assertions.assertEquals((int)1, (int)executionsUpon.size());
        InfoTree executionHierarchy = Ops.infoTree(executionsUpon.get(0));
        Assertions.assertEquals((int)0, (int)executionHierarchy.dependencies().size());
        OpInfo info = executionHierarchy.info();
        Assertions.assertTrue((boolean)info.implementationName().contains(this.getClass().getPackageName()));
    }

    @Test
    public void testPriorityProvenance() {
        ArrayList<Double> l1 = new ArrayList<Double>();
        l1.add(1.0);
        l1.add(2.0);
        l1.add(3.0);
        l1.add(4.0);
        Double out1 = (Double)ops.op("test.provenance").input(l1).outType(Double.class).apply();
        ArrayList<Long> l2 = new ArrayList<Long>();
        l2.add(5L);
        l2.add(6L);
        l2.add(7L);
        l2.add(8L);
        Double out2 = (Double)ops.op("test.provenance").input(l2).outType(Double.class).apply();
        List history1 = ops.history().executionsUpon((Object)out1);
        List history2 = ops.history().executionsUpon((Object)out2);
        Assertions.assertEquals((int)1, (int)history1.size());
        InfoTree opExecutionTree = Ops.infoTree(history1.get(0));
        Assertions.assertEquals((int)0, (int)opExecutionTree.dependencies().size());
        String expected = "public final java.util.function.Function org.scijava.ops.engine.impl.ProvenanceTest.baz";
        Assertions.assertEquals((Object)expected, (Object)opExecutionTree.info().getAnnotationBearer().toString());
        Assertions.assertEquals((int)1, (int)history2.size());
        opExecutionTree = Ops.infoTree(history2.get(0));
        Assertions.assertEquals((int)0, (int)opExecutionTree.dependencies().size());
        expected = "public final java.util.function.Function org.scijava.ops.engine.impl.ProvenanceTest.bar";
        Assertions.assertEquals((Object)expected, (Object)opExecutionTree.info().getAnnotationBearer().toString());
    }

    @Test
    public void testMappingProvenance() {
        int length = 200;
        Object[] array = new Double[length];
        Arrays.fill(array, (Object)1.0);
        String expectedName = "test.provenanceMapper";
        Thing out = (Thing)ops.op(expectedName).input((Object)array).outType(Thing.class).apply();
        List executionsUpon = ops.history().executionsUpon((Object)out);
        Assertions.assertEquals((int)1, (int)executionsUpon.size());
        String actualName = ((RichOp)executionsUpon.get(0)).name();
        Assertions.assertEquals((Object)expectedName, (Object)actualName);
    }

    @Test
    public void testMappingInfoTree() {
        int length = 200;
        Object[] array = new Double[length];
        Arrays.fill(array, (Object)1.0);
        Function mapper = ops.op("test.provenanceMapper").input((Object)array).outType(Thing.class).function();
        InfoTree tree = Ops.infoTree((Object)mapper);
        Iterator mapperInfos = ops.infos("test.provenanceMapper").iterator();
        OpInfo mapperInfo = (OpInfo)mapperInfos.next();
        Assertions.assertEquals((Object)mapperInfo, (Object)tree.info());
        Iterator mappedInfos = ops.infos("test.provenanceMapped").iterator();
        OpInfo mappedInfo = (OpInfo)mappedInfos.next();
        Assertions.assertEquals((int)1, (int)tree.dependencies().size(), (String)"Expected only one dependency of the mapper Op!");
        Assertions.assertEquals((Object)mappedInfo, (Object)((InfoTree)tree.dependencies().get(0)).info());
    }

    @Test
    public void testMappingProvenanceAndCaching() {
        int length = 200;
        Object[] array = new Double[length];
        Arrays.fill(array, (Object)1.0);
        Thing out = (Thing)ops.op("test.provenanceMapper").input((Object)array).outType(Thing.class).apply();
        List mutators = ops.history().executionsUpon((Object)out);
        Assertions.assertEquals((int)1, (int)mutators.size());
        Thing out1 = (Thing)ops.op("test.provenanceMapped").input((Object)2.0).outType(Thing.class).apply();
        mutators = ops.history().executionsUpon((Object)out);
        Assertions.assertEquals((int)1, (int)mutators.size());
        mutators = ops.history().executionsUpon((Object)out1);
        Assertions.assertEquals((int)1, (int)mutators.size());
    }

    @Test
    public void testDependencylessOpRecoveryFromString() {
        Function mapper = ops.op("test.provenanceMapped").input((Object)5.0).outType(Thing.class).function();
        Thing out = (Thing)mapper.apply(1.0);
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)out).size());
        String signature = Ops.signature((Object)mapper);
        Nil<Function<Double, Thing>> specialType = new Nil<Function<Double, Thing>>(){};
        Function actual = (Function)ops.opFromSignature(signature, (Nil)specialType);
        Assertions.assertTrue((boolean)this.wrappedOpEquality(mapper, actual));
        out = (Thing)mapper.apply(1.0);
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)out).size());
    }

    @Test
    public void testOpWithDependencyRecoveryFromString() {
        Function mapper = ops.op("test.provenanceMapper").input((Object)new Double[]{5.0, 10.0, 15.0}).outType(Thing.class).function();
        Thing out = (Thing)mapper.apply(new Double[]{1.0, 2.0});
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)out).size());
        String signature = Ops.signature((Object)mapper);
        Nil<Function<Double[], Thing>> specialType = new Nil<Function<Double[], Thing>>(){};
        Function actual = (Function)ops.opFromSignature(signature, (Nil)specialType);
        Assertions.assertTrue((boolean)this.wrappedOpEquality(mapper, actual));
        out = (Thing)actual.apply(new Double[]{1.0, 2.0});
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)out).size());
    }

    @Test
    public void testAdaptationRecoveryFromString() {
        Function f = ops.op("test.provenanceMapped").inType(Double[].class).outType(Thing[].class).function();
        Thing[] out = (Thing[])f.apply(new Double[]{1.0, 2.0});
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)out).size());
        String signature = Ops.signature((Object)f);
        Nil<Function<Double[], Thing[]>> special = new Nil<Function<Double[], Thing[]>>(){};
        Function actual = (Function)ops.opFromSignature(signature, (Nil)special);
        Assertions.assertTrue((boolean)this.wrappedOpEquality(f, actual));
        out = (Thing[])f.apply(new Double[]{1.0, 2.0});
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)out).size());
    }

    @Test
    public void testAdaptedOpWithDependencies() {
        Function f = ops.op("test.provenanceMapper").inType(Double[][].class).outType(Thing[].class).function();
        Thing[] out = (Thing[])f.apply(new Double[][]{{1.0, 2.0}});
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)out).size());
        String signature = Ops.signature((Object)f);
        Nil<Function<Double[][], Thing[]>> special = new Nil<Function<Double[][], Thing[]>>(){};
        Function actual = (Function)ops.opFromSignature(signature, (Nil)special);
        Assertions.assertTrue((boolean)this.wrappedOpEquality(f, actual));
        out = (Thing[])f.apply(new Double[][]{{1.0, 2.0}});
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)out).size());
    }

    @Test
    public void testConversionRecovery() {
        Computers.Arity1 c = ops.op("test.provenanceComputer").inType((Nil)new Nil<ObjectArray<Number>>(){}).outType((Nil)new Nil<ObjectArray<Number>>(){}).computer();
        ObjectArray in = new ObjectArray((Object[])new Number[]{1, 2, 3});
        ObjectArray actual = new ObjectArray((Object[])new Number[]{0, 0, 0});
        c.compute((Object)in, (Object)actual);
        ObjectArray expected = new ObjectArray((Object[])new Number[]{1.0, 2.0, 3.0});
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)actual).size());
        String signature = Ops.signature((Object)c);
        Nil<Computers.Arity1<ObjectArray<Number>, ObjectArray<Number>>> special = new Nil<Computers.Arity1<ObjectArray<Number>, ObjectArray<Number>>>(){};
        Computers.Arity1 fromString = (Computers.Arity1)ops.opFromSignature(signature, (Nil)special);
        Assertions.assertTrue((boolean)this.wrappedOpEquality(c, fromString));
        in = new ObjectArray((Object[])new Number[]{2, 3, 4});
        actual = new ObjectArray((Object[])new Number[]{0, 0, 0});
        fromString.compute((Object)in, (Object)actual);
        expected = new ObjectArray((Object[])new Number[]{2.0, 3.0, 4.0});
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)actual).size());
    }

    @Test
    public void testFocusedRecovery() {
        Computers.Arity1 c = ops.op("test.provenanceComputer").inType(Integer[].class).outType(Integer[].class).computer();
        Integer[] in = new Integer[]{1, 2, 3};
        Object[] actual = new Integer[]{0, 0, 0};
        c.compute((Object)in, (Object)actual);
        Object[] expected = new Integer[]{1, 2, 3};
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)actual).size());
        String signature = Ops.signature((Object)c);
        Nil<Computers.Arity1<Integer[], Integer[]>> special = new Nil<Computers.Arity1<Integer[], Integer[]>>(){};
        Computers.Arity1 fromString = (Computers.Arity1)ops.opFromSignature(signature, (Nil)special);
        in = new Integer[]{2, 3, 4};
        actual = new Integer[]{0, 0, 0};
        fromString.compute((Object)in, (Object)actual);
        expected = new Integer[]{2, 3, 4};
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)actual).size());
    }

    @Test
    public void testConversionAdaptationRecovery() {
        Function c = ops.op("test.provenanceComputer").inType(Integer[].class).outType(Integer[].class).function();
        Integer[] in = new Integer[]{1, 2, 3};
        Object[] actual = (Integer[])c.apply(in);
        Object[] expected = new Integer[]{1, 2, 3};
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)actual).size());
        String signature = Ops.signature((Object)c);
        Nil<Function<Integer[], Integer[]>> special = new Nil<Function<Integer[], Integer[]>>(){};
        Function fromString = (Function)ops.opFromSignature(signature, (Nil)special);
        Assertions.assertTrue((boolean)this.wrappedOpEquality(c, fromString));
        in = new Integer[]{2, 3, 4};
        actual = (Integer[])fromString.apply(in);
        expected = new Integer[]{2, 3, 4};
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)actual).size());
    }

    @Test
    public void testAdaptationWithDependencies() {
        Function f = ops.op("test.provenanceComputer").inType(Double[].class).outType(Double[].class).function();
        Double[] in = new Double[]{1.0, 2.0, 3.0};
        Object[] actual = (Double[])f.apply(in);
        Object[] expected = new Double[]{1.0, 2.0, 3.0};
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)actual).size());
        String signature = Ops.signature((Object)f);
        Nil<Function<Double[], Double[]>> special = new Nil<Function<Double[], Double[]>>(){};
        Function fromString = (Function)ops.opFromSignature(signature, (Nil)special);
        Assertions.assertTrue((boolean)this.wrappedOpEquality(f, fromString));
        in = new Double[]{2.0, 3.0, 4.0};
        actual = (Double[])f.apply(in);
        expected = new Double[]{2.0, 3.0, 4.0};
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
        Assertions.assertEquals((int)1, (int)ops.history().executionsUpon((Object)actual).size());
    }

    private boolean wrappedOpEquality(Object op1, Object op2) {
        boolean isRichOp1 = op1 instanceof RichOp;
        boolean isRichOp2 = op2 instanceof RichOp;
        if (isRichOp1 && isRichOp2) {
            Class<?> backingCls2;
            Class<?> backingCls1 = ((RichOp)op1).op().getClass();
            return backingCls1 == (backingCls2 = ((RichOp)op2).op().getClass());
        }
        return false;
    }

    static class Thing {
        private Double d;

        public Thing(Double d) {
            this.d = d;
        }

        private Thing append(Thing other) {
            this.d = this.d + other.getDouble();
            return this;
        }

        public Double getDouble() {
            return this.d;
        }
    }

    @OpClass(names="test.provenanceMapper")
    public static class MapperFunc
    implements Function<Double[], Thing>,
    Op {
        @OpDependency(name="test.provenanceMapped")
        public Function<Double, Thing> func;

        @Override
        public Thing apply(Double[] doubles) {
            return Arrays.stream(doubles).map(this.func).reduce((rec$, x$0) -> ((Thing)rec$).append((Thing)x$0)).orElse(null);
        }
    }
}

