/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.common3.Types;
import org.scijava.ops.engine.matcher.impl.MatchingUtils;
import org.scijava.testutil.ExampleTypes;
import org.scijava.types.Nil;
import org.scijava.types.infer.GenericAssignability;

public class MatchingUtilsTest {
    private void assertAll(Class<?> from, boolean condition, Nil<?> ... tos) {
        for (Nil<?> to : tos) {
            this.assertAll(from, condition, to.type());
        }
    }

    private void assertAll(Class<?> from, boolean condition, Type ... tos) {
        for (Type to : tos) {
            if (to instanceof ParameterizedType) {
                Assertions.assertEquals((Object)condition, (Object)GenericAssignability.checkGenericAssignability(from, (ParameterizedType)((ParameterizedType)to), (boolean)false));
                continue;
            }
            Assertions.assertEquals((Object)condition, (Object)Types.isAssignable(from, (Type)to, new HashMap()));
        }
    }

    @Test
    public <E, N extends Number> void testGenericAssignabilityVarToVar() {
        Nil y1 = new Nil<Supplier<E>>(){};
        Nil y2 = new Nil<Supplier<N>>(){};
        Nil<Double> n1 = new Nil<Double>(){};
        abstract class Single<I>
        implements Supplier<I> {
            Single() {
            }
        }
        this.assertAll(Single.class, true, y1, y2);
        this.assertAll(Single.class, false, n1);
        abstract class SingleBounded<I extends Number>
        implements Supplier<I> {
            SingleBounded() {
            }
        }
        this.assertAll(SingleBounded.class, true, y2);
        this.assertAll(SingleBounded.class, false, y1, n1);
    }

    @Test
    public void testGenericAssignabilitySingleVar() {
        Nil<Supplier<Double>> y1 = new Nil<Supplier<Double>>(){};
        Nil<Supplier<Number>> y2 = new Nil<Supplier<Number>>(){};
        Nil<Double> n1 = new Nil<Double>(){};
        abstract class Single<I>
        implements Supplier<I> {
            Single() {
            }
        }
        this.assertAll(Single.class, true, y1, y2);
        this.assertAll(Single.class, false, n1);
    }

    @Test
    public void testGenericAssignabilitySingleVarBounded() {
        Nil<Supplier<Double>> y1 = new Nil<Supplier<Double>>(){};
        Nil<Double> n1 = new Nil<Double>(){};
        Nil<String> n2 = new Nil<String>(){};
        abstract class SingleBounded<I extends Number>
        implements Supplier<I> {
            SingleBounded() {
            }
        }
        this.assertAll(SingleBounded.class, true, y1);
        this.assertAll(SingleBounded.class, false, n1, n2);
    }

    @Test
    public void testGenericAssignabilitySingleVarBoundedUsedNested() {
        Nil<Double> n1 = new Nil<Double>(){};
        Nil<String> n2 = new Nil<String>(){};
        Nil<Supplier<Double>> n3 = new Nil<Supplier<Double>>(){};
        Nil<Supplier<List<String>>> n4 = new Nil<Supplier<List<String>>>(){};
        Nil<Supplier<List<Double>>> y1 = new Nil<Supplier<List<Double>>>(){};
        abstract class SingleVarBoundedUsedNested<I extends Number>
        implements Supplier<List<I>> {
            SingleVarBoundedUsedNested() {
            }
        }
        this.assertAll(SingleVarBoundedUsedNested.class, true, y1);
        this.assertAll(SingleVarBoundedUsedNested.class, false, n1, n2, n3, n4);
    }

    @Test
    public void testGenericAssignabilitySingleVarBoundedUsedNestedAndOther() {
        Nil<Function<List<Double>, Double>> y1 = new Nil<Function<List<Double>, Double>>(){};
        Nil<Function<Double, Double>> n1 = new Nil<Function<Double, Double>>(){};
        Nil<Function<List<String>, Double>> n2 = new Nil<Function<List<String>, Double>>(){};
        Nil<Function<List<Double>, String>> n3 = new Nil<Function<List<Double>, String>>(){};
        abstract class SingleVarBoundedUsedNestedAndOther<I extends Number>
        implements Function<List<I>, Double> {
            SingleVarBoundedUsedNestedAndOther() {
            }
        }
        this.assertAll(SingleVarBoundedUsedNestedAndOther.class, true, y1);
        this.assertAll(SingleVarBoundedUsedNestedAndOther.class, false, n1, n2, n3);
        Nil<Function<List<Double>, List<Double>>> y2 = new Nil<Function<List<Double>, List<Double>>>(){};
        Nil<Function<Double, List<Double>>> n4 = new Nil<Function<Double, List<Double>>>(){};
        Nil<Function<List<String>, List<Double>>> n5 = new Nil<Function<List<String>, List<Double>>>(){};
        Nil<Function<List<Double>, List<String>>> n6 = new Nil<Function<List<Double>, List<String>>>(){};
        abstract class SingleVarBoundedUsedNestedAndOtherNested<I extends Number>
        implements Function<List<I>, List<Double>> {
            SingleVarBoundedUsedNestedAndOtherNested() {
            }
        }
        this.assertAll(SingleVarBoundedUsedNestedAndOtherNested.class, true, y2);
        this.assertAll(SingleVarBoundedUsedNestedAndOtherNested.class, false, n4, n5, n6);
        Nil<Function<Double, List<Double>>> n7 = new Nil<Function<Double, List<Double>>>(){};
        Nil<Function<List<String>, List<Double>>> n8 = new Nil<Function<List<String>, List<Double>>>(){};
        Nil<Function<List<Double>, List<String>>> n9 = new Nil<Function<List<Double>, List<String>>>(){};
        Nil<Function<List<Double>, List<Double>>> n10 = new Nil<Function<List<Double>, List<Double>>>(){};
        Nil<Function<List<Double>, List<Integer>>> n11 = new Nil<Function<List<Double>, List<Integer>>>(){};
        Nil<Function<List<Double>, List<? extends Number>>> y3 = new Nil<Function<List<Double>, List<? extends Number>>>(){};
        abstract class SingleVarBoundedUsedNestedAndOtherNestedWildcard<I extends Number>
        implements Function<List<I>, List<? extends Number>> {
            SingleVarBoundedUsedNestedAndOtherNestedWildcard() {
            }
        }
        this.assertAll(SingleVarBoundedUsedNestedAndOtherNestedWildcard.class, false, n7, n8, n9, n10, n11);
        this.assertAll(SingleVarBoundedUsedNestedAndOtherNestedWildcard.class, true, y3);
    }

    @Test
    public void testGenericAssignabilitySingleVarNestedBoundNestedAndOther() {
        Nil<Function<List<String>, Double>> y1 = new Nil<Function<List<String>, Double>>(){};
        Nil<Function<Iterable<String>, Double>> y2 = new Nil<Function<Iterable<String>, Double>>(){};
        Nil<Function<Double, Double>> n1 = new Nil<Function<Double, Double>>(){};
        Nil<Function<List<String>, String>> n2 = new Nil<Function<List<String>, String>>(){};
        Nil<Function<Iterable<Double>, Double>> n3 = new Nil<Function<Iterable<Double>, Double>>(){};
        abstract class SingleVarBoundedNestedAndOther<I extends Iterable<String>>
        implements Function<I, Double> {
            SingleVarBoundedNestedAndOther() {
            }
        }
        this.assertAll(SingleVarBoundedNestedAndOther.class, true, y1, y2);
        this.assertAll(SingleVarBoundedNestedAndOther.class, false, n1, n2, n3);
        Nil<Function<List<Integer>, List<Double>>> y3 = new Nil<Function<List<Integer>, List<Double>>>(){};
        Nil<Function<List<Double>, List<Double>>> y4 = new Nil<Function<List<Double>, List<Double>>>(){};
        Nil<Function<Iterable<Double>, List<Double>>> y5 = new Nil<Function<Iterable<Double>, List<Double>>>(){};
        Nil<Function<List<Integer>, Double>> n4 = new Nil<Function<List<Integer>, Double>>(){};
        Nil<Function<List<Double>, List<Integer>>> n5 = new Nil<Function<List<Double>, List<Integer>>>(){};
        Nil<Function<Iterable<Double>, Iterable<Double>>> n6 = new Nil<Function<Iterable<Double>, Iterable<Double>>>(){};
        Nil<Function<Integer, List<Double>>> n7 = new Nil<Function<Integer, List<Double>>>(){};
        Nil<Function<List<String>, List<Double>>> n8 = new Nil<Function<List<String>, List<Double>>>(){};
        abstract class SingleVarBoundedNestedWildcardAndOther<I extends Iterable<? extends Number>>
        implements Function<I, List<Double>> {
            SingleVarBoundedNestedWildcardAndOther() {
            }
        }
        this.assertAll(SingleVarBoundedNestedWildcardAndOther.class, true, y3, y4, y5);
        this.assertAll(SingleVarBoundedNestedWildcardAndOther.class, false, n4, n5, n6, n7, n8);
    }

    @Test
    public void testGenericAssignabilitySingleVarMultipleOccurrence() {
        Nil<Function<List<String>, List<String>>> y1 = new Nil<Function<List<String>, List<String>>>(){};
        Nil<Function<Iterable<String>, Iterable<String>>> y2 = new Nil<Function<Iterable<String>, Iterable<String>>>(){};
        Nil<Function<List<String>, List<Integer>>> n1 = new Nil<Function<List<String>, List<Integer>>>(){};
        Nil<Function<List<String>, Double>> n2 = new Nil<Function<List<String>, Double>>(){};
        abstract class SingleVarBoundedNestedMultipleOccurrence<I extends Iterable<String>>
        implements Function<I, I> {
            SingleVarBoundedNestedMultipleOccurrence() {
            }
        }
        this.assertAll(SingleVarBoundedNestedMultipleOccurrence.class, true, y1, y2);
        this.assertAll(SingleVarBoundedNestedMultipleOccurrence.class, false, n1, n2);
        Nil<Function<List<Double>, List<Double>>> y3 = new Nil<Function<List<Double>, List<Double>>>(){};
        Nil<Function<Iterable<Double>, Iterable<Double>>> y4 = new Nil<Function<Iterable<Double>, Iterable<Double>>>(){};
        Nil<Function<Iterable<Double>, Iterable<Integer>>> n3 = new Nil<Function<Iterable<Double>, Iterable<Integer>>>(){};
        Nil<Function<List<String>, Integer>> n4 = new Nil<Function<List<String>, Integer>>(){};
        abstract class SingleVarBoundedNestedWildcardMultipleOccurrence<I extends Iterable<? extends Number>>
        implements Function<I, I> {
            SingleVarBoundedNestedWildcardMultipleOccurrence() {
            }
        }
        this.assertAll(SingleVarBoundedNestedWildcardMultipleOccurrence.class, true, y3, y4);
        this.assertAll(SingleVarBoundedNestedWildcardMultipleOccurrence.class, false, n3, n4);
        Nil<Function<List<Double>, Iterable<List<Double>>>> n5 = new Nil<Function<List<Double>, Iterable<List<Double>>>>(){};
        Nil<Function<Iterable<Double>, List<Iterable<Double>>>> y5 = new Nil<Function<Iterable<Double>, List<Iterable<Double>>>>(){};
        abstract class SingleVarBoundedNestedWildcardMultipleOccurrenceUsedNested<I extends Iterable<? extends Number>>
        implements Function<I, List<I>> {
            SingleVarBoundedNestedWildcardMultipleOccurrenceUsedNested() {
            }
        }
        this.assertAll(SingleVarBoundedNestedWildcardMultipleOccurrenceUsedNested.class, true, y5);
        this.assertAll(SingleVarBoundedNestedWildcardMultipleOccurrenceUsedNested.class, false, n5);
        Nil<Function<Integer, List<Number>>> n6 = new Nil<Function<Integer, List<Number>>>(){};
        abstract class SingleVarMultipleOccurrenceUsedNested<I>
        implements Function<I, List<I>> {
            SingleVarMultipleOccurrenceUsedNested() {
            }
        }
        this.assertAll(SingleVarMultipleOccurrenceUsedNested.class, false, n6);
    }

    @Test
    public void testGenericAssignabilityDoubleVar() {
        Nil<Function<List<String>, List<String>>> y1 = new Nil<Function<List<String>, List<String>>>(){};
        Nil<Function<Iterable<String>, Iterable<String>>> y2 = new Nil<Function<Iterable<String>, Iterable<String>>>(){};
        Nil<Function<List<String>, List<Integer>>> y3 = new Nil<Function<List<String>, List<Integer>>>(){};
        Nil<Function<List<String>, Double>> y4 = new Nil<Function<List<String>, Double>>(){};
        abstract class DoubleVar<I, B>
        implements Function<I, B> {
            DoubleVar() {
            }
        }
        this.assertAll(DoubleVar.class, true, y1, y2, y3, y4);
        Nil<Function<List<String>, Double>> y5 = new Nil<Function<List<String>, Double>>(){};
        Nil<Function<List<String>, Float>> y6 = new Nil<Function<List<String>, Float>>(){};
        Nil<Function<Iterable<String>, Double>> n1 = new Nil<Function<Iterable<String>, Double>>(){};
        Nil<Function<List<Double>, Integer>> n2 = new Nil<Function<List<Double>, Integer>>(){};
        Nil<Function<List<String>, String>> n3 = new Nil<Function<List<String>, String>>(){};
        abstract class DoubleVarBounded<I extends List<String>, B extends Number>
        implements Function<I, B> {
            DoubleVarBounded() {
            }
        }
        this.assertAll(DoubleVarBounded.class, true, y5, y6);
        this.assertAll(DoubleVarBounded.class, false, n1, n2, n3);
    }

    @Test
    public void testGenericAssignabilityDoubleVarDepending() {
        Nil<Function<List<Integer>, List<Integer>>> y1 = new Nil<Function<List<Integer>, List<Integer>>>(){};
        Nil<Function<Iterable<Integer>, List<Integer>>> y2 = new Nil<Function<Iterable<Integer>, List<Integer>>>(){};
        Nil<Function<Iterable<Integer>, Iterable<Integer>>> y3 = new Nil<Function<Iterable<Integer>, Iterable<Integer>>>(){};
        Nil<Function<List<String>, List<Integer>>> n1 = new Nil<Function<List<String>, List<Integer>>>(){};
        Nil<Function<List<String>, Double>> n2 = new Nil<Function<List<String>, Double>>(){};
        Nil<Function<List<Integer>, List<Double>>> n3 = new Nil<Function<List<Integer>, List<Double>>>(){};
        Nil<Function<Integer, List<Integer>>> n4 = new Nil<Function<Integer, List<Integer>>>(){};
        Nil<Function<Iterable<Integer>, Integer>> n5 = new Nil<Function<Iterable<Integer>, Integer>>(){};
        abstract class BExtendsI<I extends Iterable<? extends Number>, B extends I>
        implements Function<I, B> {
            BExtendsI() {
            }
        }
        this.assertAll(BExtendsI.class, true, y1, y2, y3);
        this.assertAll(BExtendsI.class, false, n1, n2, n3, n4, n5);
        Nil<BiFunction<List<Integer>, List<Integer>, Integer>> y4 = new Nil<BiFunction<List<Integer>, List<Integer>, Integer>>(){};
        Nil<BiFunction<Iterable<Integer>, Iterable<Integer>, Integer>> y5 = new Nil<BiFunction<Iterable<Integer>, Iterable<Integer>, Integer>>(){};
        Nil<BiFunction<List<Integer>, List<Integer>, Double>> n6 = new Nil<BiFunction<List<Integer>, List<Integer>, Double>>(){};
        Nil<BiFunction<Iterable<Double>, Iterable<Integer>, Integer>> n7 = new Nil<BiFunction<Iterable<Double>, Iterable<Integer>, Integer>>(){};
        Nil<BiFunction<Iterable<Integer>, List<Integer>, Integer>> n8 = new Nil<BiFunction<Iterable<Integer>, List<Integer>, Integer>>(){};
        Nil<BiFunction<Iterable<String>, List<String>, String>> n9 = new Nil<BiFunction<Iterable<String>, List<String>, String>>(){};
        abstract class IBoundedByN<N extends Number, I extends Iterable<N>>
        implements BiFunction<I, I, N> {
            IBoundedByN() {
            }
        }
        this.assertAll(IBoundedByN.class, true, y4, y5);
        this.assertAll(IBoundedByN.class, false, n6, n7, n8, n9);
    }

    @Test
    public void testGenericAssignabilityDoubleVarDependingImplicitlyBounded() {
        Nil<BiFunction<Iterable<Double>, Iterable<Double>, List<String>>> y1 = new Nil<BiFunction<Iterable<Double>, Iterable<Double>, List<String>>>(){};
        abstract class IBoundedByNImplicitly<N extends Number, I extends Iterable<N>>
        implements BiFunction<I, I, List<String>> {
            IBoundedByNImplicitly() {
            }
        }
        this.assertAll(IBoundedByNImplicitly.class, true, y1);
    }

    @Test
    public void testGenericAssignabilityDoubleVarBoundedAndWildcard() {
        Nil<BiFunction<Iterable<Double>, Double, Iterable<Double>>> n1 = new Nil<BiFunction<Iterable<Double>, Double, Iterable<Double>>>(){};
        Nil<BiFunction<Double, Iterable<Double>, Iterable<Double>>> n2 = new Nil<BiFunction<Double, Iterable<Double>, Iterable<Double>>>(){};
        Nil<BiFunction<List<Float>, List<Number>, Iterable<Double>>> n3 = new Nil<BiFunction<List<Float>, List<Number>, Iterable<Double>>>(){};
        Nil<BiFunction<Iterable<Double>, List<Double>, Iterable<Double>>> n4 = new Nil<BiFunction<Iterable<Double>, List<Double>, Iterable<Double>>>(){};
        Nil<BiFunction<List<Double>, List<Double>, List<Double>>> n5 = new Nil<BiFunction<List<Double>, List<Double>, List<Double>>>(){};
        Nil<BiFunction<List<Integer>, List<Double>, Iterable<Double>>> n6 = new Nil<BiFunction<List<Integer>, List<Double>, Iterable<Double>>>(){};
        Nil<BiFunction<List<Double>, List<Double>, Iterable<Double>>> y1 = new Nil<BiFunction<List<Double>, List<Double>, Iterable<Double>>>(){};
        Nil<BiFunction<Iterable<Double>, Iterable<Double>, Iterable<Double>>> y2 = new Nil<BiFunction<Iterable<Double>, Iterable<Double>, Iterable<Double>>>(){};
        abstract class DoubleVarBoundedAndWildcard<M extends Number, I extends Iterable<? extends Number>>
        implements BiFunction<I, I, Iterable<M>> {
            DoubleVarBoundedAndWildcard() {
            }
        }
        this.assertAll(DoubleVarBoundedAndWildcard.class, true, y1, y2);
        this.assertAll(DoubleVarBoundedAndWildcard.class, false, n1, n2, n3, n4, n5, n6);
    }

    @Test
    public void testGenericAssignabilityWildcards() {
        Nil<Function<List<? extends Number>, List<? extends Number>>> y1 = new Nil<Function<List<? extends Number>, List<? extends Number>>>(){};
        Nil<Function<Iterable<Integer>, Iterable<Double>>> n1 = new Nil<Function<Iterable<Integer>, Iterable<Double>>>(){};
        Nil<Function<List<Double>, List<Integer>>> n2 = new Nil<Function<List<Double>, List<Integer>>>(){};
        Nil<Function<List<Double>, List<Double>>> n3 = new Nil<Function<List<Double>, List<Double>>>(){};
        Nil<Function<Iterable<Double>, Iterable<Double>>> n4 = new Nil<Function<Iterable<Double>, Iterable<Double>>>(){};
        abstract class Wildcards
        implements Function<List<? extends Number>, List<? extends Number>> {
            Wildcards() {
            }
        }
        this.assertAll(Wildcards.class, true, y1);
        this.assertAll(Wildcards.class, false, n1, n2, n3, n4);
    }

    @Test
    public void testGenericAssignabilityWildcardExtendingTypeVar() {
        Nil<BiConsumer<List<? extends Number>, Number>> y1 = new Nil<BiConsumer<List<? extends Number>, Number>>(){};
        Nil<BiConsumer<List<? extends Integer>, Integer>> y2 = new Nil<BiConsumer<List<? extends Integer>, Integer>>(){};
        Nil<BiConsumer<List<? extends Number>, ? extends Number>> y3 = new Nil<BiConsumer<List<? extends Number>, ? extends Number>>(){};
        Nil<BiConsumer<List<? extends Integer>, Double>> n1 = new Nil<BiConsumer<List<? extends Integer>, Double>>(){};
        abstract class StrangeConsumer<T extends Number>
        implements BiConsumer<List<? extends T>, T> {
            StrangeConsumer() {
            }
        }
        this.assertAll(StrangeConsumer.class, true, y1, y2, y3);
        this.assertAll(StrangeConsumer.class, false, n1);
    }

    @Test
    public <O extends Number> void testGenericArrayFunction() {
        Nil<Function<Double[], Double>> doubleFunction = new Nil<Function<Double[], Double>>(){};
        class Foo<I extends Number>
        implements Function<I[], Double> {
            Foo() {
            }

            @Override
            public Double apply(I[] t) {
                return null;
            }
        }
        this.assertAll(Foo.class, true, doubleFunction);
        class Bar
        implements Function<O[], Double> {
            Bar() {
            }

            @Override
            public Double apply(O[] t) {
                return null;
            }
        }
        this.assertAll(Bar.class, false, doubleFunction);
    }

    @Test
    public void testGenericArrayToWildcardWithinParameterizedType() {
        Nil<List<? extends Double[]>> upperType = new Nil<List<? extends Double[]>>(){};
        Nil<List<? super Double[]>> lowerType = new Nil<List<? super Double[]>>(){};
        abstract class Foo<T extends Number>
        implements List<T[]> {
            Foo() {
            }
        }
        this.assertAll(Foo.class, true, upperType, lowerType);
    }

    @Test
    public <T extends Number> void testSuperWildcardToSuperWildcard() {
        Nil listT = new Nil<List<? super T>>(){};
        Nil<List<? super Number>> listWildcard = new Nil<List<? super Number>>(){};
        boolean success = GenericAssignability.checkGenericAssignability((Type)listT.type(), (ParameterizedType)((ParameterizedType)listWildcard.type()), (boolean)false);
        Assertions.assertTrue((boolean)success);
    }

    @Test
    public void testNonReifiableFunction() {
        Function<Double[], Double[]> fooFunc = in -> in;
        Nil<Function<Double[], Double[]>> doubleFunc = new Nil<Function<Double[], Double[]>>(){};
        Nil<Function<Integer[], Integer[]>> integerFunc = new Nil<Function<Integer[], Integer[]>>(){};
        boolean successDouble = GenericAssignability.checkGenericAssignability(fooFunc.getClass(), (ParameterizedType)((ParameterizedType)doubleFunc.type()), (boolean)false);
        Assertions.assertTrue((boolean)successDouble);
        boolean successInteger = GenericAssignability.checkGenericAssignability(fooFunc.getClass(), (ParameterizedType)((ParameterizedType)integerFunc.type()), (boolean)false);
        Assertions.assertTrue((boolean)successInteger);
    }

    @Test
    public void testIsAssignableNullToNull() {
        Assertions.assertThrows(NullPointerException.class, () -> GenericAssignability.checkGenericAssignability(null, null, (boolean)false));
    }

    @Test
    public void testIsAssignableClassToNull() {
        Assertions.assertThrows(NullPointerException.class, () -> GenericAssignability.checkGenericAssignability(Object.class, null, (boolean)false));
    }

    @Test
    public <T extends Number> void testIsAssignableT() {
        Nil t = new Nil<T>(){};
        Nil listT = new Nil<List<T>>(){};
        Nil<List<Number>> listNumber = new Nil<List<Number>>(){};
        Nil<List<Integer>> listInteger = new Nil<List<Integer>>(){};
        Nil<List<? extends Number>> listExtendsNumber = new Nil<List<? extends Number>>(){};
        this.assertAll(List.class, true, listT, listNumber, listInteger, listExtendsNumber);
        this.assertAll(List.class, false, t);
    }

    @Test
    public <T extends Number> void testIsAssignableOutputToObject() {
        Type fooSource = new Nil<Function<T, List<T>>>(){}.type();
        Type fooFunc = new Nil<Function<Double, Object>>(){}.type();
        Assertions.assertFalse((boolean)GenericAssignability.checkGenericAssignability((Type)fooSource, (ParameterizedType)((ParameterizedType)fooFunc), (boolean)false));
        Assertions.assertTrue((boolean)GenericAssignability.checkGenericAssignability((Type)fooSource, (ParameterizedType)((ParameterizedType)fooFunc), (boolean)true));
    }

    @Test
    public <N> void testOutputAssignability() {
        Nil n = new Nil<N>(){};
        Nil ln = new Nil<List<N>>(){};
        Nil<List<? extends Number>> lWildNum = new Nil<List<? extends Number>>(){};
        Nil<List<Number>> lNum = new Nil<List<Number>>(){};
        Nil lwild = new Nil<List<?>>(){};
        HashMap typeBounds = new HashMap();
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{Integer.class}, (Type[])new Type[]{n.type()}, typeBounds));
        Type[] toOuts = new Type[]{lWildNum.type()};
        Type[] fromOuts = new Type[]{ln.type()};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.checkGenericOutputsAssignability((Type[])fromOuts, (Type[])toOuts, typeBounds));
        toOuts = new Type[]{lNum.type()};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.checkGenericOutputsAssignability((Type[])fromOuts, (Type[])toOuts, typeBounds));
        toOuts = new Type[]{lwild.type()};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.checkGenericOutputsAssignability((Type[])fromOuts, (Type[])toOuts, typeBounds));
    }

    @Test
    public void testIsApplicableRaw() {
        Type[] dest = new Type[]{Number.class, Integer.class};
        Type[] srcOK = new Type[]{Double.class, Integer.class};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])srcOK, (Type[])dest));
        Type[] srcMiss = new Type[]{String.class, Integer.class};
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])srcMiss, (Type[])dest));
    }

    @Test
    public <T extends Number, U extends BigInteger> void testIsApplicableSingle() {
        Type t = new Nil<T>(){}.type();
        Type u = new Nil<U>(){}.type();
        Type[] tDest = new Type[]{t};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{Double.class}, (Type[])tDest));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{Number.class}, (Type[])tDest));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{t}, (Type[])tDest));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{u}, (Type[])tDest));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{String.class}, (Type[])tDest));
        Type listT = new Nil<List<T>>(){}.type();
        Type[] listTDest = new Type[]{listT};
        Type listU = new Nil<List<U>>(){}.type();
        Type[] listUDest = new Type[]{listU};
        Type listDouble = new Nil<List<Double>>(){}.type();
        Type[] listDoubleDest = new Type[]{listDouble};
        Type listSuperNumber = new Nil<List<? super Number>>(){}.type();
        Type[] listSuperNumberDest = new Type[]{listSuperNumber};
        Type listExtendsNumber = new Nil<List<? extends Number>>(){}.type();
        Type[] listExtendsNumberDest = new Type[]{listExtendsNumber};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{listT}, (Type[])listTDest));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])listUDest, (Type[])listTDest));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])listTDest, (Type[])listUDest));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])listTDest, (Type[])listExtendsNumberDest));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])listUDest, (Type[])listExtendsNumberDest));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])listTDest, (Type[])listSuperNumberDest));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])listUDest, (Type[])listSuperNumberDest));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])listDoubleDest, (Type[])listExtendsNumberDest));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])listDoubleDest, (Type[])listSuperNumberDest));
        Type MapListTT = new Nil<Map<List<T>, T>>(){}.type();
        Type MapListTU = new Nil<Map<List<T>, U>>(){}.type();
        Type MapListUU = new Nil<Map<List<U>, U>>(){}.type();
        Type MapListTDouble = new Nil<Map<List<T>, Double>>(){}.type();
        Type MapListDoubleDouble = new Nil<Map<List<Double>, Double>>(){}.type();
        Type MapListDoubleString = new Nil<Map<List<Double>, String>>(){}.type();
        Type MapListDoubleNumber = new Nil<Map<List<Double>, Number>>(){}.type();
        Type MapListNumberDouble = new Nil<Map<List<Number>, Double>>(){}.type();
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{MapListTT}, (Type[])new Type[]{MapListTU}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{MapListTU}, (Type[])new Type[]{MapListTT}));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{MapListUU}, (Type[])new Type[]{MapListTT}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{MapListTT}, (Type[])new Type[]{MapListUU}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{MapListTDouble}, (Type[])new Type[]{MapListTT}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{MapListDoubleString}, (Type[])new Type[]{MapListTT}));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{MapListDoubleDouble}, (Type[])new Type[]{MapListTT}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{MapListNumberDouble}, (Type[])new Type[]{MapListTT}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{MapListDoubleNumber}, (Type[])new Type[]{MapListTT}));
    }

    @Test
    public <T extends Number, U extends String, V extends BigInteger> void testIsApplicableGenericArrays() {
        Type arrayT = new Nil<T[]>(){}.type();
        Type arrayU = new Nil<U[]>(){}.type();
        Type arrayV = new Nil<V[]>(){}.type();
        Type arrayDouble = new Nil<Double[]>(){}.type();
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{arrayDouble}, (Type[])new Type[]{arrayT}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{arrayDouble}, (Type[])new Type[]{arrayU}));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{arrayT}, (Type[])new Type[]{arrayT}));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{arrayV}, (Type[])new Type[]{arrayT}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{arrayT}, (Type[])new Type[]{arrayV}));
        Type arrayT2D = new Nil<T[][]>(){}.type();
        Type arrayV2D = new Nil<V[][]>(){}.type();
        Type arrayDouble2D = new Nil<Double[][]>(){}.type();
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{arrayDouble2D}, (Type[])new Type[]{arrayT2D}));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{arrayV2D}, (Type[])new Type[]{arrayT2D}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{arrayT2D}, (Type[])new Type[]{arrayT}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{arrayT}, (Type[])new Type[]{arrayT2D}));
        Type arrayListT = new Nil<List<T>[]>(){}.type();
        Type arrayListDouble = new Nil<List<Double>[]>(){}.type();
        Type arrayListString = new Nil<List<String>[]>(){}.type();
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{arrayListDouble}, (Type[])new Type[]{arrayListT}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{arrayListString}, (Type[])new Type[]{arrayListT}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{arrayListT}, (Type[])new Type[]{arrayU}));
    }

    @Test
    public <S, T extends ExampleTypes.Thing<S>, U extends ExampleTypes.IntegerThing, V extends ExampleTypes.RecursiveThing<V>, W extends ExampleTypes.RecursiveThing<W>, X extends ExampleTypes.Thing<S>> void testIsApplicableTypeVariables() {
        Type t = new Nil<T>(){}.type();
        Type u = new Nil<U>(){}.type();
        Type thingInt = new Nil<ExampleTypes.Thing<Integer>>(){}.type();
        Type numberThingInt = new Nil<ExampleTypes.NumberThing<Integer>>(){}.type();
        Type numberThingDouble = new Nil<ExampleTypes.NumberThing<Double>>(){}.type();
        Type strangeThingDouble = new Nil<ExampleTypes.StrangeThing<Double>>(){}.type();
        Type strangerThingString = new Nil<ExampleTypes.StrangerThing<String>>(){}.type();
        Type integerThing = new Nil<ExampleTypes.IntegerThing>(){}.type();
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{thingInt, thingInt, numberThingInt, integerThing}, (Type[])new Type[]{t, t, t, t}));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{thingInt, numberThingInt, strangerThingString}, (Type[])new Type[]{t, t, t}));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{thingInt, numberThingInt, integerThing}, (Type[])new Type[]{t, t, t}));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{numberThingInt, strangeThingDouble}, (Type[])new Type[]{t, t}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{thingInt, numberThingInt, numberThingDouble}, (Type[])new Type[]{t, t, t}));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{u}, (Type[])new Type[]{t}));
        Type circularThing = new Nil<ExampleTypes.CircularThing>(){}.type();
        Type loopingThing = new Nil<ExampleTypes.LoopingThing>(){}.type();
        Type recursiveThingCircular = new Nil<ExampleTypes.RecursiveThing<ExampleTypes.CircularThing>>(){}.type();
        Type v = new Nil<V>(){}.type();
        Type w = new Nil<W>(){}.type();
        Type x = new Nil<X>(){}.type();
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{circularThing, circularThing, loopingThing}, (Type[])new Type[]{t, t, t}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{circularThing, circularThing, loopingThing}, (Type[])new Type[]{v, v, v}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{circularThing, circularThing, recursiveThingCircular}, (Type[])new Type[]{v, v, v}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{recursiveThingCircular, recursiveThingCircular, recursiveThingCircular}, (Type[])new Type[]{v, v, v}));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{recursiveThingCircular, recursiveThingCircular, recursiveThingCircular}, (Type[])new Type[]{t, t, t}));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{circularThing, circularThing, circularThing}, (Type[])new Type[]{w, w, w}));
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{circularThing, loopingThing, circularThing}, (Type[])new Type[]{w, w, w}));
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])new Type[]{circularThing, loopingThing, circularThing}, (Type[])new Type[]{x, x, x}));
    }

    @Test
    public <T> void testIsApplicableMatchingT() {
        Type[] params = new Type[]{new Nil<List<T>>(){}.type(), new Nil<List<T>>(){}.type()};
        Type[] argsOK = new Type[]{new Nil<List<Integer>>(){}.type(), new Nil<List<Integer>>(){}.type()};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argsOK, (Type[])params));
        Type[] argsMiss = new Type[]{new Nil<List<Double>>(){}.type(), new Nil<List<Number>>(){}.type()};
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argsMiss, (Type[])params));
    }

    @Test
    public <N, C> void testIsApplicableWildcards() {
        Nil n = new Nil<List<N>>(){};
        Nil c = new Nil<List<C>>(){};
        Nil<List<? extends Number>> nWildcard = new Nil<List<? extends Number>>(){};
        Type[] params = new Type[]{n.type()};
        Type[] argsOk = new Type[]{nWildcard.type()};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argsOk, (Type[])params));
        params = new Type[]{n.type(), c.type()};
        argsOk = new Type[]{nWildcard.type(), nWildcard.type()};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argsOk, (Type[])params));
        params = new Type[]{n.type(), n.type()};
        Type[] argsNotOk = new Type[]{nWildcard.type(), nWildcard.type()};
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argsNotOk, (Type[])params));
    }

    @Test
    public <N> void testIsApplicableWildcardsInParameterizedType() {
        Nil n = new Nil<N>(){};
        Nil ln = new Nil<List<N>>(){};
        Nil<List<? extends Number>> lw = new Nil<List<? extends Number>>(){};
        Type[] params = new Type[]{n.type(), ln.type()};
        Type[] argsNotOk = new Type[]{Integer.class, lw.type()};
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argsNotOk, (Type[])params));
        params = new Type[]{ln.type(), n.type()};
        argsNotOk = new Type[]{lw.type(), Integer.class};
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argsNotOk, (Type[])params));
    }

    @Test
    public <N extends Number, C extends List<String>> void testIsApplicableBoundedWildcards() {
        Nil n = new Nil<List<N>>(){};
        Nil c = new Nil<List<C>>(){};
        Nil<List<? extends Number>> nNumberWildcard = new Nil<List<? extends Number>>(){};
        Nil<List<? extends List<String>>> nListWildcard = new Nil<List<? extends List<String>>>(){};
        Type[] params = new Type[]{n.type()};
        Type[] argsOk = new Type[]{nNumberWildcard.type()};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argsOk, (Type[])params));
        params = new Type[]{n.type(), c.type()};
        argsOk = new Type[]{nNumberWildcard.type(), nListWildcard.type()};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argsOk, (Type[])params));
        params = new Type[]{n.type(), c.type()};
        Type[] argsNotOk = new Type[]{nNumberWildcard.type(), nNumberWildcard.type()};
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argsNotOk, (Type[])params));
        params = new Type[]{n.type(), n.type()};
        argsNotOk = new Type[]{nNumberWildcard.type(), nNumberWildcard.type()};
        Assertions.assertNotEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argsNotOk, (Type[])params));
    }

    @Test
    public <I1, I2> void testIsApplicableIndirectTypeVariables() {
        Type[] param = new Type[]{new Nil<Function<I1, I2>>(){}.type()};
        abstract class NestedThingImplOK1
        implements ExampleTypes.NestedThing<Double, Double> {
            NestedThingImplOK1() {
            }
        }
        Type[] argOK = new Type[]{NestedThingImplOK1.class};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argOK, (Type[])param));
    }

    @Test
    public <I1, I2> void testIsApplicableUnboundedTypeVariables() {
        Type[] param = new Type[]{new Nil<Function<I1, I2>>(){}.type()};
        abstract class NestedThingImplOK1
        implements Function<Iterable<Double>, Consumer<Double>> {
            NestedThingImplOK1() {
            }
        }
        Type[] argOK = new Type[]{NestedThingImplOK1.class};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argOK, (Type[])param));
        abstract class NestedThingImplOK2
        implements Function<Iterable<Double>, Consumer<Integer>> {
            NestedThingImplOK2() {
            }
        }
        argOK = new Type[]{NestedThingImplOK2.class};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argOK, (Type[])param));
        abstract class NestedThingImplOK3
        implements Function<Double, Consumer<Integer>> {
            NestedThingImplOK3() {
            }
        }
        argOK = new Type[]{NestedThingImplOK3.class};
        Assertions.assertEquals((int)-1, (int)MatchingUtils.isApplicable((Type[])argOK, (Type[])param));
    }
}

