/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.reduce;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.function.Container;
import org.scijava.function.Functions;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.Ops;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.describe.BaseDescriptors;
import org.scijava.ops.engine.matcher.reduce.ReducedOpInfo;
import org.scijava.ops.engine.reduce.TestOpNullableArg;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpMethod;

public class NullableArgumentsTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.nullableMultiply")
    public final Computers.Arity3<Double[], Double[], Double[], Double[]> nullableField = new Computers.Arity3<Double[], Double[], Double[], Double[]>(){

        public void compute(Double[] in1, @Nullable Double[] in2, @Nullable Double[] in3, Double[] out) {
            if (in2 == null) {
                in2 = new Double[in1.length];
                Arrays.fill((Object[])in2, (Object)1.0);
            }
            if (in3 == null) {
                in3 = new Double[in1.length];
                Arrays.fill((Object[])in3, (Object)1.0);
            }
            for (int i = 0; i < in1.length; ++i) {
                out[i] = in1[i] * in2[i] * in3[i];
            }
        }
    };
    private static final String PERMUTED_NAME = "test.nullableOr";
    private static final String TEST_DESC = "This Op should be reduced";

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new BaseDescriptors()});
        ops.register(new Object[]{new NullableArgumentsTest()});
        ops.register(new Object[]{new TestOpNullableArg()});
    }

    @Test
    public void testClassWithTwoNullables() {
        Double sum = (Double)ops.op("test.nullableAdd").input((Object)2.0, (Object)5.0, (Object)7.0).outType(Double.class).apply();
        Double expected = 14.0;
        Assertions.assertEquals((Double)expected, (Double)sum);
    }

    @Test
    public void testClassWithOneNullable() {
        Double sum = (Double)ops.op("test.nullableAdd").input((Object)2.0, (Object)5.0).outType(Double.class).apply();
        Double expected = 7.0;
        Assertions.assertEquals((Double)expected, (Double)sum);
    }

    @Test
    public void testClassWithoutNullables() {
        Double sum = (Double)ops.op("test.nullableAdd").input((Object)2.0).outType(Double.class).apply();
        Double expected = 2.0;
        Assertions.assertEquals((Double)expected, (Double)sum);
    }

    @Test
    public void testFieldWithTwoNullables() {
        Double[] d1 = new Double[]{2.0};
        Double[] d2 = new Double[]{5.0};
        Double[] d3 = new Double[]{7.0};
        Double[] o = new Double[]{50.0};
        ops.op("test.nullableMultiply").input((Object)d1, (Object)d2, (Object)d3).output((Object)o).compute();
        Double expected = 70.0;
        Assertions.assertEquals((Double)expected, (Double)o[0]);
    }

    @Test
    public void testFieldWithOneNullable() {
        Double[] d1 = new Double[]{2.0};
        Double[] d2 = new Double[]{5.0};
        Double[] o = new Double[]{50.0};
        ops.op("test.nullableMultiply").input((Object)d1, (Object)d2).output((Object)o).compute();
        Double expected = 10.0;
        Assertions.assertEquals((Double)expected, (Double)o[0]);
    }

    @Test
    public void testFieldWithoutNullables() {
        Double[] d1 = new Double[]{2.0};
        Double[] o = new Double[]{50.0};
        ops.op("test.nullableMultiply").input((Object)d1).output((Object)o).compute();
        Double expected = 2.0;
        Assertions.assertEquals((Double)expected, (Double)o[0]);
    }

    @OpMethod(names="test.nullableConcatenate", type=Functions.Arity3.class)
    public static String nullableMethod(String in1, @Nullable String in2, @Nullable String in3) {
        if (in2 == null) {
            in2 = "";
        }
        if (in3 == null) {
            in3 = "";
        }
        return in1.concat(in2).concat(in3);
    }

    @Test
    public void testMethodWithTwoNullables() {
        String out = (String)ops.op("test.nullableConcatenate").input((Object)"a", (Object)"b", (Object)"c").outType(String.class).apply();
        String expected = "abc";
        Assertions.assertEquals((Object)expected, (Object)out);
    }

    @Test
    public void testMethodWithOneNullable() {
        String out = (String)ops.op("test.nullableConcatenate").input((Object)"a", (Object)"b").outType(String.class).apply();
        String expected = "ab";
        Assertions.assertEquals((Object)expected, (Object)out);
    }

    @Test
    public void testMethodWithoutNullables() {
        String out = (String)ops.op("test.nullableConcatenate").input((Object)"a").outType(String.class).apply();
        String expected = "a";
        Assertions.assertEquals((Object)expected, (Object)out);
    }

    @OpMethod(names="test.nullableOr", type=Computers.Arity3_3.class)
    public static void nullablePermutedComputer(int[] in1, @Nullable int[] in2, @Container int[] out, @Nullable int[] in3) {
        if (in2 == null) {
            in2 = new int[in1.length];
        }
        if (in3 == null) {
            in3 = new int[in1.length];
        }
        for (int i = 0; i < out.length; ++i) {
            out[i] = in1[i] | in2[i] | in3[i];
        }
    }

    @Test
    public void testPermutedMethodWithTwoNullables() {
        int[] out = new int[1];
        ops.op(PERMUTED_NAME).input((Object)new int[]{1}, (Object)new int[]{2}, (Object)new int[]{4}).output((Object)out).compute();
        Assertions.assertEquals((int)7, (int)out[0]);
    }

    @Test
    public void testPermutedMethodWithOneNullable() {
        int[] out = new int[1];
        ops.op(PERMUTED_NAME).input((Object)new int[]{1}, (Object)new int[]{2}).output((Object)out).compute();
        Assertions.assertEquals((int)3, (int)out[0]);
    }

    @Test
    public void testPermutedMethodWithoutNullables() {
        int[] out = new int[1];
        ops.op(PERMUTED_NAME).input((Object)new int[]{1}).output((Object)out).compute();
        Assertions.assertEquals((int)1, (int)out[0]);
    }

    @Test
    public void testNullableHelp() {
        String expected = "test.nullableOr:\n\t- (number[], number[] = null, @CONTAINER number[], number[] = null) -> None";
        Assertions.assertEquals((Object)expected, (Object)ops.op(PERMUTED_NAME).help());
    }

    @OpMethod(names="math.sub", type=BiFunction.class, description="This Op should be reduced")
    public static Double nullableFunction(Double in1, @Nullable Double in2) {
        if (in2 == null) {
            return in1;
        }
        return in1 - in2;
    }

    @Test
    public void testToString() {
        Function op = ops.op("math.sub").input((Object)1.0).function();
        OpInfo info = Ops.info((Object)op);
        Assertions.assertInstanceOf(ReducedOpInfo.class, (Object)info);
        Assertions.assertEquals((Object)TEST_DESC, (Object)info.description());
        Assertions.assertTrue((boolean)info.toString().contains(TEST_DESC));
    }
}

