/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.util;

import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.math.Add;
import org.scijava.ops.engine.math.Sqrt;
import org.scijava.types.Nil;

public class ComputersTest
extends AbstractTestEnvironment {
    private static Nil<double[]> nilDoubleArray = new Nil<double[]>(){};

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new Sqrt()});
        ops.register(new Object[]{new Add()});
    }

    @Test
    public void testUnaryComputers() {
        Computers.Arity1 sqrtComputer = OpBuilder.matchComputer((OpEnvironment)ops, (String)"math.sqrt", nilDoubleArray, nilDoubleArray);
        double[] result = new double[3];
        sqrtComputer.compute((Object)new double[]{4.0, 100.0, 25.0}, (Object)result);
        ComputersTest.arrayEquals(result, 2.0, 1.0, 5.0);
    }

    @Test
    public void testBinaryComputers() {
        Computers.Arity2 addComputer = OpBuilder.matchComputer((OpEnvironment)ops, (String)"math.add", nilDoubleArray, nilDoubleArray, nilDoubleArray);
        double[] result = new double[3];
        addComputer.compute((Object)new double[]{4.0, 100.0, 25.0}, (Object)new double[]{4.0, 10.0, 1.5}, (Object)result);
        ComputersTest.arrayEquals(result, 8.0, 110.0, 26.5);
    }
}

