/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.util;

import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Inplaces;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.math.Add;
import org.scijava.ops.engine.math.Sqrt;
import org.scijava.types.Nil;

public class InplacesTest
extends AbstractTestEnvironment {
    private static Nil<double[]> nilDoubleArray = new Nil<double[]>(){};

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new Sqrt()});
        ops.register(new Object[]{new Add()});
    }

    @Test
    public void testUnaryInplaces() {
        Inplaces.Arity1 inplaceSqrt = OpBuilder.matchInplace((OpEnvironment)ops, (String)"math.sqrt", nilDoubleArray);
        double[] a1 = new double[]{4.0, 100.0, 36.0};
        inplaceSqrt.mutate((Object)a1);
        assert (InplacesTest.arrayEquals(a1, 2.0, 10.0, 6.0));
    }

    @Test
    public void testBinaryInplaces() {
        Inplaces.Arity2_1 inplaceAdd = OpBuilder.matchInplace2_1((OpEnvironment)ops, (String)"math.add", nilDoubleArray, nilDoubleArray);
        double[] a1 = new double[]{3.0, 5.0, 7.0};
        double[] a2 = new double[]{2.0, 4.0, 9.0};
        inplaceAdd.mutate((Object)a1, (Object)a2);
        assert (InplacesTest.arrayEquals(a1, 5.0, 9.0, 16.0));
    }
}

