/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.conversionLoss.impl;

import org.scijava.ops.engine.conversionLoss.LossReporter;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpHints;
import org.scijava.types.Nil;

public class PrimitiveLossReporters
implements OpCollection {
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.lossReporter")
    public final IntToDecimalReporter<Long, Double> LongDoubleReporter = (from, to) -> {
        long maxValue = 0x7FFFFFFFFFFFFFFEL;
        double converted = maxValue;
        return Math.abs(maxValue - (long)converted);
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.lossReporter")
    public final LossReporter<Double, Long> DoubleLongReporter = (from, to) -> {
        double maxValue = Double.MAX_VALUE;
        long converted = (long)maxValue;
        return maxValue - (double)converted;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.lossReporter")
    public final LossReporter<Long, Integer> LongIntegerReporter = (from, to) -> {
        long maxValue = Long.MAX_VALUE;
        int converted = (int)maxValue;
        return Math.abs(maxValue - (long)converted);
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.lossReporter")
    public final LossReporter<Integer, Long> IntegerLongReporter = (from, to) -> 0.0;
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.lossReporter")
    public final IntToDecimalReporter<Integer, Double> IntegerDoubleReporter = (from, to) -> {
        long maxValue = Integer.MAX_VALUE;
        double converted = maxValue;
        return Math.abs(maxValue - (long)converted);
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.lossReporter")
    public final LossReporter<Double, Integer> DoubleIntegerReporter = (from, to) -> {
        double maxValue = Double.MAX_VALUE;
        int converted = (int)maxValue;
        return maxValue - (double)converted;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.lossReporter")
    public final LossReporter<Number, Double> NumberDoubleReporter = (from, to) -> this.LongDoubleReporter.apply((Nil<Long>)Nil.of(Long.class), (Nil<Double>)Nil.of(Double.class));
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.lossReporter")
    public final LossReporter<Number, Long> NumberLongReporter = (from, to) -> this.DoubleLongReporter.apply((Nil<Double>)Nil.of(Double.class), (Nil<Long>)Nil.of(Long.class));

    @FunctionalInterface
    static interface IntToDecimalReporter<T, R>
    extends LossReporter<T, R> {
        public Double intToDecimalLoss(Nil<T> var1, Nil<R> var2);

        @Override
        default public Double apply(Nil<T> from, Nil<R> to) {
            return 1.0 + this.intToDecimalLoss(from, to);
        }
    }
}

