/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.scijava.ops.api.OpHistory;
import org.scijava.ops.api.RichOp;

public class DefaultOpHistory
implements OpHistory {
    private final Map<Object, List<RichOp<?>>> mutationMap = new WeakHashMap();

    public List<RichOp<?>> executionsUpon(Object o) {
        if (o.getClass().isPrimitive()) {
            throw new IllegalArgumentException("Cannot determine the executions upon a primitive as they are passed by reference!");
        }
        return this.mutationMap.getOrDefault(o, Collections.emptyList());
    }

    public void logOutput(RichOp<?> op, Object output) {
        if (!this.mutationMap.containsKey(output)) {
            this.updateList(output);
        }
        this.resolveExecution(op, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateList(Object output) {
        Map<Object, List<RichOp<?>>> map = this.mutationMap;
        synchronized (map) {
            this.mutationMap.putIfAbsent(output, new ArrayList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveExecution(RichOp<?> op, Object output) {
        List<RichOp<?>> l = this.mutationMap.get(output);
        if (l != null) {
            List<RichOp<?>> list = l;
            synchronized (list) {
                l.add(op);
            }
        }
    }

    public double priority() {
        return -10000.0;
    }
}

