/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.impl;

import java.util.Collections;
import java.util.List;
import org.scijava.meta.Versions;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.OpInfoGenerator;
import org.scijava.ops.engine.matcher.impl.DefaultOpClassInfo;
import org.scijava.ops.engine.util.Infos;
import org.scijava.ops.spi.Op;
import org.scijava.ops.spi.OpClass;
import org.scijava.ops.spi.OpHints;

public class OpClassOpInfoGenerator
implements OpInfoGenerator {
    private Hints formHints(OpHints h) {
        if (h == null) {
            return new Hints(new String[0]);
        }
        return new Hints(h.hints());
    }

    protected List<OpInfo> processClass(Class<?> c) {
        OpClass p = c.getAnnotation(OpClass.class);
        if (p == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new DefaultOpClassInfo(c, Versions.of(c), p.description(), this.formHints(c.getAnnotation(OpHints.class)), p.priority(), Infos.parseNames(p.names())));
    }

    @Override
    public boolean canGenerateFrom(Object o) {
        boolean isOp = o instanceof Op;
        boolean isOpClass = o.getClass().isAnnotationPresent(OpClass.class);
        return isOp && isOpClass;
    }

    @Override
    public List<OpInfo> generateInfosFrom(Object o) {
        return this.processClass(o.getClass());
    }
}

