/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.common3.Types;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.OpRequest;
import org.scijava.struct.Member;
import org.scijava.struct.Struct;
import org.scijava.struct.StructInstance;

public class OpCandidate {
    private final OpEnvironment env;
    private final OpRequest request;
    private final OpInfo info;
    private final Map<TypeVariable<?>, Type> typeVarAssigns;
    private final Type reifiedType;
    private StatusCode code;
    private String message;
    private Member<?> statusItem;
    private final Type[] paddedArgs;

    public OpCandidate(OpEnvironment env, OpRequest request, OpInfo info, Map<TypeVariable<?>, Type> typeVarAssigns) {
        this.env = env;
        this.request = request;
        this.info = info;
        this.typeVarAssigns = typeVarAssigns;
        this.paddedArgs = this.padTypes(this, this.getRequest().argTypes());
        this.reifiedType = OpCandidate.getReifiedType(request, info, typeVarAssigns);
    }

    public OpCandidate(OpEnvironment env, OpRequest request, OpInfo info) {
        this(env, request, info, OpCandidate.typeVarAssignsFromRequestAndInfo(request, info));
    }

    public static Type getReifiedType(OpRequest request, OpInfo info, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type exactSuperType = Types.superTypeOf((Type)info.opType(), (Class)Types.raw((Type)request.type()));
        return Types.unroll((Type)exactSuperType, typeVarAssigns);
    }

    public OpEnvironment env() {
        return this.env;
    }

    public OpRequest getRequest() {
        return this.request;
    }

    public OpInfo opInfo() {
        return this.info;
    }

    public Type getType() {
        return this.reifiedType;
    }

    public double priority() {
        return this.info.priority();
    }

    public Map<TypeVariable<?>, Type> typeVarAssigns() {
        return this.typeVarAssigns;
    }

    public Type[] paddedArgs() {
        return this.paddedArgs;
    }

    public Struct struct() {
        return this.info.struct();
    }

    public void setStatus(StatusCode code) {
        this.setStatus(code, null, null);
    }

    public void setStatus(StatusCode code, String message) {
        this.setStatus(code, message, null);
    }

    public void setStatus(StatusCode code, String message, Member<?> item) {
        this.code = code;
        this.message = message;
        this.statusItem = item;
    }

    public StatusCode getStatusCode() {
        return this.code;
    }

    public Member<?> getStatusItem() {
        return this.statusItem;
    }

    public String getStatus() {
        StatusCode statusCode = this.getStatusCode();
        if (statusCode == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        switch (statusCode) {
            case MATCH: {
                sb.append("MATCH");
                break;
            }
            case OUTPUT_TYPES_DO_NOT_MATCH: {
                sb.append("Output types do not match");
                break;
            }
            case TOO_MANY_ARGS: {
                sb.append("Too many arguments");
                break;
            }
            case TOO_FEW_ARGS: {
                sb.append("Not enough arguments");
                break;
            }
            case ARG_TYPES_DO_NOT_MATCH: {
                sb.append("Argument types do not match");
                break;
            }
            case REQUIRED_ARG_IS_NULL: {
                sb.append("Missing required argument");
                break;
            }
            case CANNOT_CONVERT: {
                sb.append("Inconvertible type");
                break;
            }
            case DOES_NOT_CONFORM: {
                sb.append("Inputs do not conform to op rules");
                break;
            }
            default: {
                return this.message;
            }
        }
        String msg = this.message;
        if (msg != null) {
            sb.append(": ").append(msg);
        }
        return sb.toString();
    }

    public String toString() {
        return this.info.toString();
    }

    public StructInstance<?> createOpInstance(List<?> dependencies) {
        if (this.getStatusCode().equals((Object)StatusCode.MATCH)) {
            return this.opInfo().createOpInstance(dependencies);
        }
        throw new IllegalStateException("Status of candidate to create op from indicates a problem: " + this.getStatus());
    }

    public Object createOp(List<?> dependencies) {
        return this.createOpInstance(dependencies).object();
    }

    private static Map<TypeVariable<?>, Type> typeVarAssignsFromRequestAndInfo(OpRequest request, OpInfo info) {
        HashMap typeVarAssigns = new HashMap();
        if (!request.typesMatch(info.opType(), typeVarAssigns)) {
            throw new IllegalArgumentException("OpInfo " + info + " cannot satisfy the requirements contained within OpRequest " + request);
        }
        return typeVarAssigns;
    }

    private Type[] padTypes(OpCandidate candidate, Type[] types) {
        Object[] padded = this.padArgs(candidate, types);
        return (Type[])Arrays.copyOf(padded, padded.length, Type[].class);
    }

    private Object[] padArgs(OpCandidate candidate, Object ... args) {
        List members = candidate.opInfo().inputs();
        String argName = "args";
        int inputCount = 0;
        int requiredCount = 0;
        for (Member item : members) {
            ++inputCount;
            if (item.isRequired()) continue;
            ++requiredCount;
        }
        if (args.length == inputCount) {
            return args;
        }
        if (args.length > inputCount) {
            candidate.setStatus(StatusCode.TOO_MANY_ARGS, "\nNumber of " + argName + " given: " + args.length + "  >  Number of " + argName + " of op: " + inputCount);
            return null;
        }
        if (args.length < requiredCount) {
            candidate.setStatus(StatusCode.TOO_FEW_ARGS, "\nNumber of " + argName + " given: " + args.length + "  <  Number of required " + argName + " of op: " + requiredCount);
            return null;
        }
        int argsToPad = inputCount - args.length;
        int nullableCount = inputCount - requiredCount;
        int nullablesToFill = nullableCount - argsToPad;
        Object[] paddedArgs = new Object[inputCount];
        int argIndex = 0;
        int paddedIndex = 0;
        int nullableIndex = 0;
        for (Member item : members) {
            if (!item.isRequired() && nullableIndex++ >= nullablesToFill) {
                ++paddedIndex;
                continue;
            }
            paddedArgs[paddedIndex++] = args[argIndex++];
        }
        return paddedArgs;
    }

    public static enum StatusCode {
        MATCH,
        OUTPUT_TYPES_DO_NOT_MATCH,
        TOO_MANY_ARGS,
        TOO_FEW_ARGS,
        ARG_TYPES_DO_NOT_MATCH,
        REQUIRED_ARG_IS_NULL,
        CANNOT_CONVERT,
        DOES_NOT_CONFORM,
        OTHER;

    }
}

