/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.adapt;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.scijava.common3.Types;
import org.scijava.ops.api.InfoTree;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.InfoTreeGenerator;
import org.scijava.ops.engine.matcher.adapt.OpAdaptationInfo;
import org.scijava.struct.Member;

public class AdaptationInfoTreeGenerator
implements InfoTreeGenerator {
    @Override
    public InfoTree generate(OpEnvironment env, String signature, Map<String, OpInfo> idMap, Collection<InfoTreeGenerator> generators) {
        String adaptorComponent = signature.substring(signature.indexOf("|Adaptor:"), signature.indexOf("|OriginalOp:"));
        if (!adaptorComponent.startsWith("|Adaptor:")) {
            throw new IllegalArgumentException("Adaptor component " + adaptorComponent + " must begin with prefix |Adaptor:");
        }
        String adaptorSignature = adaptorComponent.substring("|Adaptor:".length());
        InfoTree adaptorTree = InfoTreeGenerator.generateDependencyTree(env, adaptorSignature, idMap, generators);
        String originalComponent = signature.substring(signature.indexOf("|OriginalOp:"));
        if (!originalComponent.startsWith("|OriginalOp:")) {
            throw new IllegalArgumentException("Original Op component " + originalComponent + " must begin with prefix |OriginalOp:");
        }
        String originalSignature = originalComponent.substring("|OriginalOp:".length());
        InfoTree originalTree = InfoTreeGenerator.generateDependencyTree(env, originalSignature, idMap, generators);
        OpInfo originalInfo = originalTree.info();
        HashMap typeVarAssigns = new HashMap();
        if (!Types.isAssignable((Type)originalInfo.opType(), (Type)((Member)adaptorTree.info().inputs().get(0)).type(), typeVarAssigns)) {
            throw new IllegalArgumentException("The adaptor cannot be used on Op " + originalInfo);
        }
        Type adaptedOpType = Types.unroll((Type)adaptorTree.info().output().type(), typeVarAssigns);
        OpAdaptationInfo adaptedInfo = new OpAdaptationInfo(originalInfo, adaptedOpType, adaptorTree);
        return new InfoTree((OpInfo)adaptedInfo, originalTree.dependencies());
    }

    @Override
    public boolean canGenerate(String signature) {
        return signature.startsWith("|Adaptation:");
    }
}

