/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.adapt;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.InfoTree;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.OpInstance;
import org.scijava.ops.engine.struct.FunctionalMethodType;
import org.scijava.ops.engine.struct.FunctionalParameters;
import org.scijava.ops.engine.struct.OpRetypingMemberParser;
import org.scijava.ops.engine.struct.RetypingRequest;
import org.scijava.ops.engine.util.Infos;
import org.scijava.struct.MemberParser;
import org.scijava.struct.Struct;
import org.scijava.struct.StructInstance;
import org.scijava.struct.Structs;
import org.scijava.types.Nil;

public class OpAdaptationInfo
implements OpInfo {
    protected static final String IMPL_DECLARATION = "|Adaptation:";
    protected static final String ADAPTOR = "|Adaptor:";
    protected static final String ORIGINAL = "|OriginalOp:";
    private final OpInfo srcInfo;
    private final InfoTree adaptorTree;
    private final Type type;
    private final Hints hints;
    private Struct struct;

    public OpAdaptationInfo(OpInfo srcInfo, Type type, InfoTree adaptorTree) {
        this.srcInfo = srcInfo;
        this.adaptorTree = adaptorTree;
        this.type = type;
        this.hints = srcInfo.declaredHints().plus(new String[]{"adaptation.FORBIDDEN"});
        List<FunctionalMethodType> fmts = FunctionalParameters.findFunctionalMethodTypes(type);
        RetypingRequest r = new RetypingRequest(srcInfo.struct(), fmts);
        this.struct = Structs.from((Object)r, (Type)type, (MemberParser[])new MemberParser[]{new OpRetypingMemberParser()});
        Infos.validate(this);
    }

    public String description() {
        return this.srcInfo.description();
    }

    public List<String> names() {
        return this.srcInfo.names();
    }

    public Type opType() {
        return this.type;
    }

    public Struct struct() {
        return this.struct;
    }

    public Hints declaredHints() {
        return this.hints;
    }

    public double priority() {
        return this.srcInfo.priority() - 1.0;
    }

    public String implementationName() {
        return this.srcInfo.implementationName() + ADAPTOR + this.adaptorTree.signature();
    }

    public StructInstance<?> createOpInstance(List<?> dependencies) {
        OpInstance adaptorInstance = this.adaptorTree.newInstance(new Nil<Function<Object, Object>>(){}.type());
        Object op = this.srcInfo.createOpInstance(dependencies).object();
        Object adaptedOp = ((Function)adaptorInstance.op()).apply(op);
        return this.struct().createInstance(adaptedOp);
    }

    public AnnotatedElement getAnnotationBearer() {
        return this.srcInfo.getAnnotationBearer();
    }

    public String version() {
        return this.adaptorTree.info().version();
    }

    public String id() {
        return "|Adaptation:|Adaptor:" + this.adaptorTree.signature() + ORIGINAL + this.srcInfo.id();
    }

    public String toString() {
        String description = Infos.describe(this);
        StringBuilder sb = new StringBuilder();
        sb.append(this.srcInfo.implementationName());
        sb.append("\n\tAdaptor: ");
        sb.append(this.adaptorTree.toString().replace("\n", "\n\t"));
        int nameBreak = description.indexOf(10);
        sb.append(description.substring(nameBreak));
        return sb.toString();
    }
}

