/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.OpMatchingException;
import org.scijava.ops.api.OpRequest;
import org.scijava.ops.engine.MatchingConditions;
import org.scijava.ops.engine.matcher.MatchingResult;
import org.scijava.ops.engine.matcher.OpCandidate;
import org.scijava.ops.engine.matcher.OpMatcher;
import org.scijava.ops.engine.matcher.convert.Conversions;
import org.scijava.ops.engine.matcher.impl.RuntimeSafeMatchingRoutine;

public class ConversionMatchingRoutine
extends RuntimeSafeMatchingRoutine {
    @Override
    public void checkSuitability(MatchingConditions conditions) throws OpMatchingException {
        if (conditions.hints().containsAny(new String[]{"conversion.IN_PROGRESS", "conversion.FORBIDDEN"})) {
            throw new OpMatchingException("Conversion is disabled");
        }
        if (conditions.request().name().startsWith("engine.")) {
            throw new OpMatchingException("Conversion is unsuitable for internal engine Ops");
        }
    }

    @Override
    public OpCandidate findMatch(MatchingConditions conditions, OpMatcher matcher, OpEnvironment env) {
        MatchingConditions convertConditions = MatchingConditions.from(conditions.request(), conditions.hints().plus(new String[]{"conversion.IN_PROGRESS"}));
        OpRequest request = conditions.request();
        ArrayList<OpCandidate> candidates = new ArrayList<OpCandidate>();
        for (OpInfo info : env.infos(request.name(), convertConditions.hints())) {
            Conversions.tryConvert(env, info, request).ifPresent(converted -> candidates.add(new OpCandidate(env, request, (OpInfo)converted, converted.typeVarAssigns())));
        }
        List<OpCandidate> matches = this.filterMatches(candidates);
        try {
            return new MatchingResult(candidates, matches, Collections.singletonList(request)).singleMatch();
        }
        catch (OpMatchingException e) {
            throw new OpMatchingException("Unable to find Op conversion pathway for " + convertConditions, (Throwable)e);
        }
    }

    @Override
    public double priority() {
        return -10000.0;
    }
}

