/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.convert;

import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.scijava.common3.Any;
import org.scijava.common3.Types;
import org.scijava.function.Container;
import org.scijava.function.Mutable;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.OpMatchingException;
import org.scijava.ops.api.OpRequest;
import org.scijava.ops.api.Ops;
import org.scijava.ops.api.RichOp;
import org.scijava.ops.engine.matcher.convert.ConvertedOpInfo;
import org.scijava.types.Nil;
import org.scijava.types.infer.FunctionalInterfaces;
import org.scijava.types.infer.GenericAssignability;

public final class Conversions {
    private Conversions() {
    }

    public static int mutableIndexOf(Type t) {
        Method method = FunctionalInterfaces.functionalMethodOf((Type)t);
        AnnotatedType[] params = method.getAnnotatedParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (params[i].isAnnotationPresent(Container.class)) {
                return i;
            }
            if (!params[i].isAnnotationPresent(Mutable.class)) continue;
            return i;
        }
        return -1;
    }

    public static Optional<ConvertedOpInfo> tryConvert(OpEnvironment env, OpInfo info, OpRequest request) {
        try {
            return Optional.ofNullable(Conversions.convert(env, info, request));
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    private static ConvertedOpInfo convert(OpEnvironment env, OpInfo info, OpRequest request) {
        Type opType = info.opType();
        Type reqType = request.type();
        if (!Types.isAssignable((Type)Types.raw((Type)opType), (Type)Types.raw((Type)reqType))) {
            return null;
        }
        Hints h = new Hints(new String[]{"adaptation.FORBIDDEN", "conversion.FORBIDDEN", "history.IGNORE"});
        HashMap vars = new HashMap();
        Type[] fromArgs = request.argTypes();
        List<Type> toArgs = Conversions.inputTypesAgainst(info, Types.raw((Type)reqType));
        ArrayList preConverters = new ArrayList();
        for (int i = 0; i < fromArgs.length; ++i) {
            RichOp<Function<?, ?>> opt = Conversions.findConverter(fromArgs[i], toArgs.get(i), vars, env, h);
            preConverters.add(opt);
        }
        Optional<ConvertedOpInfo> opt = Conversions.postprocessFunction(info, request, preConverters, vars, env, h);
        if (opt.isPresent()) {
            return opt.get();
        }
        opt = Conversions.postprocessIdentity(info, request, preConverters, vars, env);
        if (opt.isPresent()) {
            return opt.get();
        }
        opt = Conversions.postprocessConvertAndCopy(info, request, preConverters, vars, env, h);
        if (opt.isPresent()) {
            return opt.get();
        }
        opt = Conversions.postprocessCopy(info, request, preConverters, vars, env, h);
        return opt.orElse(null);
    }

    private static List<Type> inputTypesAgainst(OpInfo info, Class<?> against) {
        int toIoIndex;
        List types = info.inputTypes();
        int fromIoIndex = Conversions.mutableIndexOf(info.opType());
        if (fromIoIndex != (toIoIndex = Conversions.mutableIndexOf(against))) {
            types.add(toIoIndex, (Type)types.remove(fromIoIndex));
        }
        return types;
    }

    private static Optional<ConvertedOpInfo> postprocessFunction(OpInfo info, OpRequest request, List<RichOp<Function<?, ?>>> preConverters, Map<TypeVariable<?>, Type> vars, OpEnvironment env, Hints hints) {
        int ioIndex = Conversions.mutableIndexOf(request.type());
        if (ioIndex > -1) {
            return Optional.empty();
        }
        Nil fromOut = Nil.of((Type)Types.unroll((Type)info.outputType(), vars));
        Nil toOut = Nil.of((Type)request.outType());
        RichOp postConverter = Ops.rich((Object)env.op("engine.convert", hints).inType(fromOut).outType(toOut).function());
        return Optional.of(new ConvertedOpInfo(info, request.type(), preConverters, Arrays.asList(request.argTypes()), postConverter, request.outType(), null, env, vars));
    }

    private static Optional<ConvertedOpInfo> postprocessIdentity(OpInfo info, OpRequest request, List<RichOp<Function<?, ?>>> preConverters, Map<TypeVariable<?>, Type> vars, OpEnvironment env) {
        int ioIndex = Conversions.mutableIndexOf(request.type());
        if (ioIndex == -1) {
            return Optional.empty();
        }
        if (Ops.info(preConverters.get(ioIndex)).names().contains("engine.identity")) {
            return Optional.of(new ConvertedOpInfo(info, request.type(), preConverters, Arrays.asList(request.argTypes()), null, request.outType(), null, env, vars));
        }
        return Optional.empty();
    }

    private static Optional<ConvertedOpInfo> postprocessConvertAndCopy(OpInfo info, OpRequest request, List<RichOp<Function<?, ?>>> preConverters, Map<TypeVariable<?>, Type> vars, OpEnvironment env, Hints hints) {
        int ioIndex = Conversions.mutableIndexOf(request.type());
        if (ioIndex == -1) {
            return Optional.empty();
        }
        try {
            Nil fromOut = Nil.of((Type)Types.unroll((Type)info.outputType(), vars));
            Nil toOut = Nil.of((Type)request.outType());
            RichOp postConverter = Ops.rich((Object)env.op("engine.convert", hints).inType(fromOut).outType(toOut).function());
            RichOp copyOp = Ops.rich((Object)env.op("engine.copy", hints).inType(toOut).outType(toOut).computer());
            return Optional.of(new ConvertedOpInfo(info, request.type(), preConverters, Arrays.asList(request.argTypes()), postConverter, request.outType(), copyOp, env, vars));
        }
        catch (OpMatchingException e) {
            return Optional.empty();
        }
    }

    private static Optional<ConvertedOpInfo> postprocessCopy(OpInfo info, OpRequest request, List<RichOp<Function<?, ?>>> preConverters, Map<TypeVariable<?>, Type> vars, OpEnvironment env, Hints hints) {
        int ioIndex = Conversions.mutableIndexOf(request.type());
        if (ioIndex == -1) {
            return Optional.empty();
        }
        try {
            Nil fromOut = Nil.of((Type)Types.unroll((Type)info.outputType(), vars));
            Nil toOut = Nil.of((Type)request.outType());
            RichOp postConverter = Ops.rich((Object)env.op("engine.identity", hints).inType(fromOut).outType(fromOut).function());
            RichOp copyOp = Ops.rich((Object)env.op("engine.copy", hints).inType(fromOut).outType(toOut).computer());
            return Optional.of(new ConvertedOpInfo(info, request.type(), preConverters, Arrays.asList(request.argTypes()), postConverter, request.outType(), copyOp, env, vars));
        }
        catch (OpMatchingException e) {
            return Optional.empty();
        }
    }

    private static RichOp<Function<?, ?>> findConverter(Type from, Type to, Map<TypeVariable<?>, Type> vars, OpEnvironment env, Hints hints) {
        Nil source = Nil.of((Type)from);
        Type preDest = Types.unroll((Type)to, vars);
        Nil<?> dest = Conversions.wildcardVacuousTypeVars(preDest);
        Function op = env.op("engine.convert", hints).inType(source).outType(dest).function();
        RichOp rich = Ops.rich((Object)op);
        Conversions.resolveTypes(from, preDest, rich, vars);
        return Ops.rich((Object)op);
    }

    private static void resolveTypes(Type source, Type dest, RichOp<? extends Function<?, ?>> rich, Map<TypeVariable<?>, Type> vars) {
        ParameterizedType reqType = Types.parameterize(Function.class, (Type[])new Type[]{source, dest});
        Type infoType = rich.instance().type();
        GenericAssignability.inferTypeVariables((Type[])new Type[]{reqType}, (Type[])new Type[]{infoType}, vars);
    }

    private static Nil<?> wildcardVacuousTypeVars(Type t) {
        Type[] typeParams = Types.typeParamsOf((Type)t, (Class)Types.raw((Type)t));
        if (t instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t;
            return Nil.of((Type)new Any(tv.getBounds()));
        }
        HashMap<TypeVariable, Any> vars = new HashMap<TypeVariable, Any>();
        for (Type typeParam : typeParams) {
            if (!(typeParam instanceof TypeVariable)) continue;
            TypeVariable from = (TypeVariable)typeParam;
            Any to = new Any(from.getBounds());
            vars.put(from, to);
        }
        return Nil.of((Type)Types.unroll((Type)t, vars));
    }

    static String getClassName(Type t) {
        Class clazz = Types.raw((Type)t);
        String className = clazz.getSimpleName();
        if (className.chars().allMatch(Character::isJavaIdentifierPart)) {
            return className;
        }
        if (clazz.isArray()) {
            return clazz.getComponentType().getSimpleName() + "_Arr";
        }
        return className;
    }
}

