/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.convert;

import java.util.function.Function;
import org.scijava.collections.ObjectArray;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpHints;

public class PrimitiveArrayConverters<N extends Number>
implements OpCollection {
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<N[], ObjectArray<Number>> fromNumber = arr -> {
        ObjectArray oa = new ObjectArray(Number.class, ((Number[])arr).length);
        for (int i = 0; i < ((Number[])arr).length; ++i) {
            oa.set(i, (Object)arr[i]);
        }
        return oa;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<byte[], ObjectArray<Number>> fromPrimitiveByte = arr -> {
        ObjectArray oa = new ObjectArray(Number.class, ((byte[])arr).length);
        for (int i = 0; i < ((byte[])arr).length; ++i) {
            oa.set(i, (Object)arr[i]);
        }
        return oa;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<short[], ObjectArray<Number>> fromPrimitiveShort = arr -> {
        ObjectArray oa = new ObjectArray(Number.class, ((short[])arr).length);
        for (int i = 0; i < ((short[])arr).length; ++i) {
            oa.set(i, (Object)arr[i]);
        }
        return oa;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<int[], ObjectArray<Number>> fromPrimitiveInt = arr -> {
        ObjectArray oa = new ObjectArray(Number.class, ((int[])arr).length);
        for (int i = 0; i < ((int[])arr).length; ++i) {
            oa.set(i, (Object)arr[i]);
        }
        return oa;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<long[], ObjectArray<Number>> fromPrimitiveLong = arr -> {
        ObjectArray oa = new ObjectArray(Number.class, ((long[])arr).length);
        for (int i = 0; i < ((long[])arr).length; ++i) {
            oa.set(i, (Object)arr[i]);
        }
        return oa;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<float[], ObjectArray<Number>> fromPrimitiveFloat = arr -> {
        ObjectArray oa = new ObjectArray(Number.class, ((float[])arr).length);
        for (int i = 0; i < ((float[])arr).length; ++i) {
            oa.set(i, (Object)Float.valueOf(arr[i]));
        }
        return oa;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<double[], ObjectArray<Number>> fromPrimitiveDouble = arr -> {
        ObjectArray oa = new ObjectArray(Number.class, ((double[])arr).length);
        for (int i = 0; i < ((double[])arr).length; ++i) {
            oa.set(i, (Object)arr[i]);
        }
        return oa;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<ObjectArray<Number>, Byte[]> toByte = o -> (Byte[])o.stream().map(b -> b == null ? null : Byte.valueOf(b.byteValue())).toArray(Byte[]::new);
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<ObjectArray<Number>, Integer[]> toInteger = o -> (Integer[])o.stream().map(i -> i == null ? null : Integer.valueOf(i.intValue())).toArray(Integer[]::new);
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<ObjectArray<Number>, Short[]> toShort = o -> (Short[])o.stream().map(s -> s == null ? null : Short.valueOf(s.shortValue())).toArray(Short[]::new);
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<ObjectArray<Number>, Long[]> toLong = o -> (Long[])o.stream().map(l -> l == null ? null : Long.valueOf(l.longValue())).toArray(Long[]::new);
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<ObjectArray<Number>, Float[]> toFloat = o -> (Float[])o.stream().map(f -> f == null ? null : Float.valueOf(f.floatValue())).toArray(Float[]::new);
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<ObjectArray<Number>, Double[]> toDouble = o -> (Double[])o.stream().map(d -> d == null ? null : Double.valueOf(d.doubleValue())).toArray(Double[]::new);
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<ObjectArray<Number>, byte[]> toPrimitiveByte = o -> {
        byte[] arr = new byte[o.size()];
        for (int i = 0; i < o.size(); ++i) {
            arr[i] = ((Number)o.get(i)).byteValue();
        }
        return arr;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<ObjectArray<Number>, short[]> toPrimitiveShort = o -> {
        short[] arr = new short[o.size()];
        for (int i = 0; i < o.size(); ++i) {
            arr[i] = ((Number)o.get(i)).shortValue();
        }
        return arr;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<ObjectArray<Number>, int[]> toPrimitiveInt = o -> {
        int[] arr = new int[o.size()];
        for (int i = 0; i < o.size(); ++i) {
            arr[i] = ((Number)o.get(i)).intValue();
        }
        return arr;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<ObjectArray<Number>, long[]> toPrimitiveLong = o -> {
        long[] arr = new long[o.size()];
        for (int i = 0; i < o.size(); ++i) {
            arr[i] = ((Number)o.get(i)).longValue();
        }
        return arr;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<ObjectArray<Number>, float[]> toPrimitiveFloat = o -> {
        float[] arr = new float[o.size()];
        for (int i = 0; i < o.size(); ++i) {
            arr[i] = ((Number)o.get(i)).floatValue();
        }
        return arr;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<ObjectArray<Number>, double[]> toPrimitiveDouble = o -> {
        double[] arr = new double[o.size()];
        for (int i = 0; i < o.size(); ++i) {
            arr[i] = ((Number)o.get(i)).doubleValue();
        }
        return arr;
    };
}

