/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.scijava.common3.Types;
import org.scijava.ops.api.OpRequest;
import org.scijava.types.infer.GenericAssignability;

public class DefaultOpRequest
implements OpRequest {
    private final String name;
    private final Type type;
    private final Type outType;
    private final Type[] args;

    public static DefaultOpRequest fromTypes(String name, Type type, Type outType, Type ... args) {
        return new DefaultOpRequest(name, type, outType, OpRequest.filterNulls((Type[])args));
    }

    public DefaultOpRequest(String name, Type type, Type outType, Type[] args) {
        this.name = name;
        this.type = type;
        this.outType = outType;
        this.args = args;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public Type outType() {
        return this.outType;
    }

    public Type[] argTypes() {
        return (Type[])this.args.clone();
    }

    public String label() {
        StringBuilder sb = new StringBuilder();
        OpRequest.append((StringBuilder)sb, (String)this.name);
        if (this.type != null) {
            OpRequest.append((StringBuilder)sb, (String)Types.name((Type)this.type));
        }
        return sb.toString();
    }

    public boolean typesMatch(Type opType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (this.type == null) {
            return true;
        }
        return !(this.type instanceof ParameterizedType ? !GenericAssignability.checkGenericAssignability((Type)opType, (ParameterizedType)((ParameterizedType)this.type), typeVarAssigns, (boolean)true) : !Types.isAssignable((Type)opType, (Type)this.type));
    }

    public String toString() {
        return this.requestString();
    }

    public boolean equals(Object obj) {
        return this.requestEquals(obj);
    }

    public int hashCode() {
        return this.requestHashCode();
    }
}

