/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.reduce;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.matcher.reduce.ReductionUtils;
import org.scijava.ops.engine.struct.FunctionalMethodType;
import org.scijava.ops.engine.struct.OpResizingMemberParser;
import org.scijava.ops.engine.struct.RetypingRequest;
import org.scijava.ops.engine.util.Infos;
import org.scijava.struct.Member;
import org.scijava.struct.MemberParser;
import org.scijava.struct.Struct;
import org.scijava.struct.StructInstance;
import org.scijava.struct.Structs;

public class ReducedOpInfo
implements OpInfo {
    protected static final String IMPL_DECLARATION = "|Reduction:";
    protected static final String PARAMS_REDUCED = "|ParamsReduced:";
    protected static final String ORIGINAL_INFO = "|OriginalInfo:";
    private final OpInfo srcInfo;
    private final Type reducedOpType;
    private final int paramsReduced;
    private final Hints hints;
    private final Struct struct;

    public ReducedOpInfo(OpInfo src, Type reducedOpType, int paramsReduced) {
        this.srcInfo = src;
        this.reducedOpType = reducedOpType;
        this.paramsReduced = paramsReduced;
        this.hints = this.srcInfo.declaredHints().plus(new String[]{"reduction.FORBIDDEN"});
        RetypingRequest r = this.retypingRequest();
        this.struct = Structs.from((Object)r, (Type)reducedOpType, (MemberParser[])new MemberParser[]{new OpResizingMemberParser()});
    }

    private RetypingRequest retypingRequest() {
        if (this.srcInfo.output().isInput()) {
            return this.mutableOutputOpRetypingRequest();
        }
        return this.pureOutputOpRetypingRequest();
    }

    private RetypingRequest mutableOutputOpRetypingRequest() {
        List inputs = this.srcInfo.inputs();
        int retainedPureInputs = inputs.size() - this.paramsReduced - 1;
        ArrayList<FunctionalMethodType> newFmts = new ArrayList<FunctionalMethodType>();
        int addedPureInputs = 0;
        for (Member m : this.srcInfo.inputs()) {
            if (!m.isOutput() && addedPureInputs < retainedPureInputs) {
                newFmts.add(new FunctionalMethodType(m));
                ++addedPureInputs;
                continue;
            }
            if (!m.isOutput()) continue;
            newFmts.add(new FunctionalMethodType(m));
        }
        return new RetypingRequest(this.srcInfo.struct(), newFmts);
    }

    private RetypingRequest pureOutputOpRetypingRequest() {
        List inputs = this.srcInfo.inputs();
        long retainedPureInputs = inputs.size() - this.paramsReduced;
        List<FunctionalMethodType> newFmts = inputs.stream().limit(retainedPureInputs).map(FunctionalMethodType::new).collect(Collectors.toList());
        newFmts.add(new FunctionalMethodType(this.srcInfo.output()));
        return new RetypingRequest(this.srcInfo.struct(), newFmts);
    }

    public Type opType() {
        return this.reducedOpType;
    }

    public Struct struct() {
        return this.struct;
    }

    public Hints declaredHints() {
        return this.hints;
    }

    public List<String> names() {
        return this.srcInfo.names();
    }

    public String description() {
        return this.srcInfo.description();
    }

    public double priority() {
        return this.srcInfo.priority();
    }

    public String implementationName() {
        return this.srcInfo.implementationName() + "Reduction" + this.paramsReduced;
    }

    public StructInstance<?> createOpInstance(List<?> dependencies) {
        Object op = this.srcInfo.createOpInstance(dependencies).object();
        try {
            Object reducedOp = ReductionUtils.javassistOp(op, this);
            return this.struct().createInstance(reducedOp);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Failed to invoke reduction of Op: \n" + this.srcInfo + "\nProvided Op dependencies were: " + Objects.toString(dependencies), ex);
        }
    }

    public AnnotatedElement getAnnotationBearer() {
        return this.srcInfo.getAnnotationBearer();
    }

    public String version() {
        return this.srcInfo().version();
    }

    public String id() {
        StringBuilder sb = new StringBuilder(IMPL_DECLARATION);
        sb.append(PARAMS_REDUCED);
        sb.append(this.paramsReduced());
        sb.append(ORIGINAL_INFO);
        sb.append(this.srcInfo().id());
        return sb.toString();
    }

    public OpInfo srcInfo() {
        return this.srcInfo;
    }

    public int paramsReduced() {
        return this.paramsReduced;
    }

    public String toString() {
        return Infos.describe(this);
    }
}

