/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.struct;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.scijava.common3.Types;
import org.scijava.ops.engine.exceptions.impl.FunctionalTypeOpException;
import org.scijava.ops.engine.struct.FunctionalParameters;
import org.scijava.ops.engine.struct.SynthesizedMethodParameterData;
import org.scijava.ops.engine.struct.SynthesizedParameterMember;
import org.scijava.struct.MemberParser;
import org.scijava.struct.Structs;
import org.scijava.types.infer.FunctionalInterfaces;

public class ClassParameterMemberParser
implements MemberParser<Class<?>, SynthesizedParameterMember<?>> {
    public List<SynthesizedParameterMember<?>> parse(Class<?> source, Type structType) {
        Method opMethod;
        if (source == null) {
            return null;
        }
        ArrayList items = new ArrayList();
        Structs.checkModifiers((String)(source.getName() + ": "), (int)source.getModifiers(), (boolean)true, (int[])new int[]{1024});
        try {
            opMethod = this.getDeclaredOpMethod(source);
        }
        catch (NoSuchMethodException e1) {
            throw new IllegalArgumentException("Class " + source.getName() + " does not have a functional method!", e1);
        }
        Class fIface = FunctionalInterfaces.findFrom(source);
        SynthesizedMethodParameterData paramData = new SynthesizedMethodParameterData(opMethod, fIface);
        try {
            FunctionalParameters.parseFunctionalParameters(items, source, paramData);
        }
        catch (IllegalArgumentException exc) {
            throw new FunctionalTypeOpException(source, (Throwable)exc);
        }
        return items;
    }

    private Method getDeclaredOpMethod(Class<?> c) throws NoSuchMethodException {
        Method fMethod = FunctionalInterfaces.functionalMethodOf(c);
        Type[] paramTypes = Types.paramTypesOf((Method)fMethod, c);
        Class[] rawParamTypes = (Class[])Arrays.stream(paramTypes).map(t -> Types.raw((Type)t)).toArray(Class[]::new);
        try {
            return c.getMethod(fMethod.getName(), rawParamTypes);
        }
        catch (NoSuchMethodException e) {
            return fMethod;
        }
    }
}

