/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.struct;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.common3.Types;
import org.scijava.function.Container;
import org.scijava.function.Mutable;
import org.scijava.ops.engine.struct.FunctionalMethodType;
import org.scijava.ops.engine.struct.ParameterData;
import org.scijava.ops.engine.struct.SynthesizedParameterMember;
import org.scijava.ops.engine.util.internal.AnnotationUtils;
import org.scijava.ops.spi.Nullable;
import org.scijava.struct.ItemIO;
import org.scijava.struct.Structs;
import org.scijava.types.infer.FunctionalInterfaces;

public final class FunctionalParameters {
    private FunctionalParameters() {
    }

    public static void parseFunctionalParameters(ArrayList<SynthesizedParameterMember<?>> items, Type type, ParameterData data) {
        List<FunctionalMethodType> fmts = FunctionalParameters.findFunctionalMethodTypes(type);
        List<SynthesizedParameterMember<?>> fmtMembers = data.synthesizeMembers(fmts);
        for (SynthesizedParameterMember<?> m : fmtMembers) {
            Class itemType = Types.raw((Type)m.type());
            if ((m.getIOType() == ItemIO.MUTABLE || m.getIOType() == ItemIO.CONTAINER) && Structs.isImmutable((Class)itemType)) {
                throw new IllegalArgumentException("Immutable " + m.getIOType() + " parameter: " + m.key() + " (" + itemType.getName() + " is immutable)");
            }
            items.add(m);
        }
    }

    public static List<FunctionalMethodType> findFunctionalMethodTypes(Type functionalType) {
        Method functionalMethod = FunctionalInterfaces.functionalMethodOf((Type)functionalType);
        if (functionalMethod == null) {
            throw new IllegalArgumentException("Type " + functionalType + " is not a functional type, thus its functional method types cannot be determined");
        }
        Type paramfunctionalType = functionalType;
        if (functionalType instanceof Class) {
            paramfunctionalType = Types.parameterize((Class)((Class)functionalType), (Type[])new Type[0]);
        }
        ArrayList<FunctionalMethodType> out = new ArrayList<FunctionalMethodType>();
        int i = 0;
        for (Type t : Types.paramTypesOf((Method)functionalMethod, (Type)paramfunctionalType)) {
            ItemIO ioType = AnnotationUtils.getMethodParameterAnnotation(functionalMethod, i, Container.class) != null ? ItemIO.CONTAINER : (AnnotationUtils.getMethodParameterAnnotation(functionalMethod, i, Mutable.class) != null ? ItemIO.MUTABLE : ItemIO.INPUT);
            out.add(new FunctionalMethodType(t, ioType));
            ++i;
        }
        Type returnType = Types.returnTypeOf((Method)functionalMethod, (Type)paramfunctionalType);
        if (!returnType.equals(Void.TYPE)) {
            out.add(new FunctionalMethodType(returnType, ItemIO.OUTPUT));
        }
        return out;
    }

    public static Boolean hasNullableAnnotations(Method m) {
        return Arrays.stream(m.getParameters()).anyMatch(p -> p.isAnnotationPresent(Nullable.class));
    }

    public static Boolean[] findParameterNullability(Method m) {
        return (Boolean[])Arrays.stream(m.getParameters()).map(p -> p.isAnnotationPresent(Nullable.class)).toArray(Boolean[]::new);
    }

    public static List<Method> fMethodsWithNullable(Class<?> opClass) {
        Method superFMethod = FunctionalInterfaces.functionalMethodOf(opClass);
        return Arrays.stream(opClass.getMethods()).filter(m -> m.getName().equals(superFMethod.getName())).filter(m -> m.getParameterCount() == superFMethod.getParameterCount()).filter(m -> FunctionalParameters.hasNullableAnnotations(m)).collect(Collectors.toList());
    }

    public static Boolean[] generateAllRequiredArray(int num) {
        Object[] arr = new Boolean[num];
        Arrays.fill(arr, (Object)false);
        return arr;
    }
}

