/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.scijava.common3.Types;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.OpDependencyMember;
import org.scijava.ops.engine.exceptions.impl.InvalidOpNameException;
import org.scijava.ops.engine.exceptions.impl.MultipleOutputsOpException;
import org.scijava.ops.engine.exceptions.impl.UnnamedOpException;
import org.scijava.struct.ItemIO;
import org.scijava.struct.Member;

public final class Infos {
    private Infos() {
    }

    public static String[] parseNames(String names) {
        return (String[])Arrays.stream(names.split(",")).map(String::trim).toArray(String[]::new);
    }

    public static void validate(OpInfo info) {
        long numOutputs = info.struct().members().stream().filter(Member::isOutput).count();
        if (numOutputs > 1L) {
            throw new MultipleOutputsOpException((Object)info.implementationName());
        }
        if (Objects.isNull(info.names()) || info.names().isEmpty()) {
            throw new UnnamedOpException((Object)info.implementationName());
        }
        for (String name : info.names()) {
            if (name.contains(".")) continue;
            throw new InvalidOpNameException(info, name);
        }
    }

    public static int IOIndex(OpInfo info) {
        List inputs = info.inputs();
        Optional<Member> ioArg = inputs.stream().filter(m -> m.isInput() && m.isOutput()).findFirst();
        if (ioArg.isEmpty()) {
            return -1;
        }
        Member ioMember = ioArg.get();
        return inputs.indexOf(ioMember);
    }

    public static boolean hasPureOutput(OpInfo info) {
        return Infos.IOIndex(info) == -1;
    }

    public static List<OpDependencyMember<?>> dependencies(OpInfo info) {
        return info.struct().members().stream().filter(m -> m instanceof OpDependencyMember).map(m -> (OpDependencyMember)m).collect(Collectors.toList());
    }

    public static String describe(OpInfo info) {
        StringBuilder sb = new StringBuilder(info.implementationName());
        if (!info.description().isEmpty()) {
            Object desc = info.description().replaceAll("\n", "\n\t");
            if (((String)desc).endsWith("\n\t")) {
                desc = ((String)desc).substring(0, ((String)desc).lastIndexOf("\n\t"));
            }
            sb.append("\n\t").append((String)desc);
        }
        for (Member member : info.inputs()) {
            sb.append("\n\t");
            sb.append("> ").append(member.key()).append(member.isRequired() ? "" : " (optional)").append(" : ");
            if (member.getIOType() == ItemIO.CONTAINER) {
                sb.append("@CONTAINER ");
            } else if (member.getIOType() == ItemIO.MUTABLE) {
                sb.append("@MUTABLE ");
            }
            sb.append(Infos.typeString(member.type(), true));
            if (member.description().isBlank()) continue;
            sb.append("\n\t\t").append(member.description().replaceAll("\n\\s*", "\n\t\t"));
        }
        Member output = info.output();
        if (output.getIOType() == ItemIO.OUTPUT) {
            sb.append("\n\tReturns : ").append(Infos.typeString(output.type(), true));
        }
        return sb.toString();
    }

    private static String typeString(Type input, boolean verbose) {
        String str = input.getTypeName();
        if (verbose) {
            return str;
        }
        if (input instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)input).getBounds();
            CharSequence[] s = new String[bounds.length];
            for (int i = 0; i < s.length; ++i) {
                s[i] = Infos.typeString(Types.raw((Type)bounds[i]), false);
            }
            return String.join((CharSequence)"+", s);
        }
        if (input instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)input;
            String raw = Infos.typeString(pType.getRawType(), false);
            Type[] args = pType.getActualTypeArguments();
            CharSequence[] s = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                s[i] = Infos.typeString(args[i], false);
            }
            return raw + "<" + String.join((CharSequence)", ", s) + ">";
        }
        return str.replaceAll("([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*([a-zA-Z_$][a-zA-Z\\d_$]*)", "$2");
    }
}

