/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.tutorial;

import io.scif.img.ImgOpener;
import io.scif.img.SCIFIOImgPlus;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import org.scijava.Context;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.types.Nil;

public class OpsIntro {
    public static void main(String ... args) {
        OpEnvironment ops = OpEnvironment.build();
        int numberOfOps = OpsIntro.count(ops.infos());
        System.out.println("There are " + numberOfOps + " ops in the OpEnvironment");
        int numberOfGaussianOps = OpsIntro.count(ops.infos("filter.gauss"));
        System.out.println("There are " + numberOfGaussianOps + " gaussian filters in the OpEnvironment");
        Double result = (Double)ops.op("math.add").input((Object)1.0, (Object)1.0).outType(Double.class).apply();
        System.out.println("1+1=" + result);
        Img<?> img = OpsIntro.openLymp();
        RectangleShape shape = new RectangleShape(5, false);
        Nil<Img<UnsignedByteType>> uByteType = new Nil<Img<UnsignedByteType>>(){};
        Img mean = (Img)ops.op("filter.mean").input(img, (Object)shape).outType((Nil)uByteType).apply();
        Object multResult = ops.op("create.img").input(img, (Object)new IntType()).apply();
        ops.op("math.multiply").input(img, (Object)mean).output(multResult).compute();
        System.out.println("--- All Ops!!! ---");
        System.out.println(ops.help());
        System.out.println("--- Available 'math.multiply' ops ---");
        System.out.println(ops.help("math.multiply"));
    }

    private static int count(Iterable<?> iterable) {
        int num = 0;
        for (Object ignored : iterable) {
            ++num;
        }
        return num;
    }

    private static Img<?> openLymp() {
        Img img = null;
        try (Context ctx = new Context();){
            ImgOpener opener = new ImgOpener(ctx);
            img = ((SCIFIOImgPlus)opener.openImgs("https://imagej.net/images/lymp.tif").get(0)).getImg();
        }
        return img;
    }
}

