/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.tutorial;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.progress.Progress;
import org.scijava.progress.Task;
import org.scijava.types.Nil;

public class ReportingProgress {
    public final Function<Integer, List<Long>> primes = numPrimes -> {
        ArrayList<Long> primes = new ArrayList<Long>();
        long val = 1L;
        Progress.defineTotal((long)numPrimes.intValue());
        while (primes.size() < numPrimes) {
            long sqrt = (long)Math.sqrt(++val);
            boolean couldBePrime = true;
            int i = 2;
            while ((long)i <= sqrt) {
                if (val % (long)i == 0L) {
                    couldBePrime = false;
                    break;
                }
                ++i;
            }
            if (!couldBePrime) continue;
            primes.add(val);
            Progress.update();
        }
        return primes;
    };

    public static void main(String ... args) {
        OpEnvironment ops = OpEnvironment.build();
        ops.setDefaultHints(new Hints(new String[]{"progress.TRACK"}));
        Consumer<Task> l = System.out::println;
        Progress.addGlobalListener(l);
        Function op = ops.op("tutorial.long.op").inType(Integer.class).outType((Nil)new Nil<List<Long>>(){}).function();
        int numPrimes = 100;
        List primes = (List)op.apply(numPrimes);
        System.out.println("First " + numPrimes + " primes: " + primes);
    }
}

