/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.types.extract;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Optional;
import org.scijava.common3.Any;
import org.scijava.common3.GenericTyped;
import org.scijava.common3.Types;
import org.scijava.types.extract.TypeExtractor;

public interface TypeReifier {
    public Optional<TypeExtractor> getExtractor(Class<?> var1);

    default public Type reify(Object o) {
        if (o == null) {
            return new Any();
        }
        if (o instanceof GenericTyped) {
            return ((GenericTyped)o).type();
        }
        Class<?> c = o.getClass();
        for (TypeToken token : TypeToken.of(c).getTypes()) {
            Optional<TypeExtractor> opt = this.getExtractor(token.getRawType());
            if (!opt.isPresent()) continue;
            return opt.get().reify(this, o);
        }
        TypeVariable<Class<?>>[] typeVars = c.getTypeParameters();
        if (typeVars.length == 0) {
            return c;
        }
        HashMap resolved = new HashMap();
        for (TypeVariable<Class<?>> typeVar : typeVars) {
            resolved.putIfAbsent(typeVar, Any.class);
        }
        return Types.parameterize(c, resolved);
    }
}

