/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.types.infer;

import com.google.common.base.Objects;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.scijava.common3.Any;
import org.scijava.common3.Types;
import org.scijava.types.infer.TypeInferenceException;
import org.scijava.types.infer.TypeMapping;
import org.scijava.types.infer.TypeVarAssigns;
import org.scijava.types.infer.WildcardTypeMapping;

public final class GenericAssignability {
    private GenericAssignability() {
    }

    public static boolean checkGenericAssignability(Type src, ParameterizedType dest, boolean safeAssignability) {
        return GenericAssignability.checkGenericAssignability(src, dest, null, safeAssignability);
    }

    public static boolean checkGenericAssignability(Type src, ParameterizedType dest, Map<TypeVariable<?>, Type> typeVarAssigns, boolean safeAssignability) {
        if (typeVarAssigns == null) {
            typeVarAssigns = new HashMap();
        } else if (!typeVarAssigns.isEmpty()) {
            throw new IllegalArgumentException("Expected empty typeVarAssigns but contained " + typeVarAssigns.size() + " entries");
        }
        if (!Types.isAssignable((Type)Types.raw((Type)src), (Type)Types.raw((Type)dest))) {
            return false;
        }
        Type[] srcTypes = Types.typeParamsOf((Type)src, (Class)Types.raw((Type)dest));
        Type[] destTypes = dest.getActualTypeArguments();
        if (srcTypes.length == 0) {
            return Types.isAssignable((Type)src, (Type)dest);
        }
        boolean result = GenericAssignability.checkGenericAssignability(srcTypes, destTypes, src, dest, typeVarAssigns, safeAssignability);
        return result;
    }

    public static Map<TypeVariable<?>, Type> inferTypeVariables(Type type, Type inferFrom) {
        HashMap map = new HashMap();
        GenericAssignability.inferTypeVariables(new Type[]{type}, new Type[]{inferFrom}, map);
        return map;
    }

    public static void inferTypeVariables(Type[] types, Type[] inferFroms, Map<TypeVariable<?>, Type> typeVarAssigns) {
        HashMap typeMappings = new HashMap();
        try {
            GenericAssignability.inferTypeVariables(types, inferFroms, typeMappings, true);
            typeVarAssigns.putAll(new TypeVarAssigns(typeMappings));
        }
        catch (TypeInferenceException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isSafeAssignable(Type[] destTypes, Map<TypeVariable<?>, Type> typeVarAssigns, Type src, Type dest) {
        Method[] destMethods = (Method[])Arrays.stream(Types.raw((Type)dest).getDeclaredMethods()).filter(method -> Modifier.isAbstract(method.getModifiers())).toArray(Method[]::new);
        if (destMethods.length == 0) {
            throw new IllegalArgumentException(src + " does not have an abstract method!");
        }
        Type[] params = Types.paramTypesOf((Method)destMethods[0], (Type)src);
        Type returnType = Types.returnTypeOf((Method)destMethods[0], (Type)src);
        for (int i = 0; i < params.length; ++i) {
            if (Types.isAssignable((Type)destTypes[i], (Type)params[i], typeVarAssigns)) continue;
            return false;
        }
        if (returnType == Void.TYPE) {
            return true;
        }
        if (Any.class.equals((Object)destTypes[destTypes.length - 1])) {
            return true;
        }
        return Types.isAssignable((Type)returnType, (Type)destTypes[destTypes.length - 1], typeVarAssigns);
    }

    public static Type[] mapVarToTypes(Type[] typesToMap, Map<TypeVariable<?>, Type> typeAssigns) {
        return (Type[])Arrays.stream(typesToMap).map(type -> Types.unroll((Map)typeAssigns, (Type)type, (boolean)false)).toArray(Type[]::new);
    }

    private static boolean checkGenericAssignability(Type[] srcTypes, Type[] destTypes, Type src, Type dest, Map<TypeVariable<?>, Type> typeVarAssigns, boolean safeAssignability) {
        if (srcTypes.length != destTypes.length) {
            return false;
        }
        try {
            GenericAssignability.inferTypeVariables(srcTypes, destTypes, typeVarAssigns);
        }
        catch (IllegalArgumentException e) {
            return safeAssignability && GenericAssignability.isSafeAssignable(destTypes, typeVarAssigns, src, dest);
        }
        Class matchingRawType = Types.raw((Type)dest);
        Type[] mappedSrcTypes = GenericAssignability.mapVarToTypes(srcTypes, typeVarAssigns);
        ParameterizedType inferredSrcType = Types.parameterize((Class)matchingRawType, (Type[])mappedSrcTypes);
        if (Types.isAssignable((Type)inferredSrcType, (Type)dest, typeVarAssigns)) {
            return true;
        }
        return safeAssignability && GenericAssignability.isSafeAssignable(destTypes, typeVarAssigns, src, dest);
    }

    private static Type getInferrableBound(WildcardType type) {
        Type[] lBounds = type.getLowerBounds();
        Type[] uBounds = type.getUpperBounds();
        if (lBounds.length == 1 && uBounds.length == 1 && uBounds[0] == Object.class) {
            return lBounds[0];
        }
        if (lBounds.length == 0 && uBounds.length == 1) {
            return uBounds[0];
        }
        throw new IllegalArgumentException("Illegal WildcardType: Current Java Language Specification does not allow " + type + " to simultaneously have upper bounds " + uBounds + " and lower bounds " + lBounds);
    }

    private static void inferTypeVariables(Class<?> type, Type inferFrom, Map<TypeVariable<?>, TypeMapping> typeMappings) {
        Type current;
        TypeVarAssigns typeVarAssigns;
        if (inferFrom instanceof TypeVariable && Types.isAssignable(type, (Type)inferFrom, (Map)(typeVarAssigns = new TypeVarAssigns(typeMappings))) && (current = typeVarAssigns.putIfAbsent((TypeVariable)inferFrom, type)) != null) {
            if (Any.is((Object)current)) {
                typeVarAssigns.put((TypeVariable)inferFrom, type);
            } else if (!Objects.equal(type, (Object)current)) {
                throw new TypeInferenceException();
            }
        }
    }

    private static void inferTypeVariablesFromGenericArray(GenericArrayType type, Type inferFrom, Map<TypeVariable<?>, TypeMapping> typeMappings, boolean malleable) {
        if (inferFrom instanceof Class && ((Class)inferFrom).isArray()) {
            Type componentType = type.getGenericComponentType();
            Class<?> componentInferFrom = ((Class)inferFrom).getComponentType();
            GenericAssignability.inferTypeVariables(componentType, componentInferFrom, typeMappings, malleable);
        } else if (inferFrom instanceof WildcardType) {
            Type inferrableBound = GenericAssignability.getInferrableBound((WildcardType)inferFrom);
            boolean newMalleable = ((WildcardType)inferFrom).getLowerBounds().length == 1;
            GenericAssignability.inferTypeVariables(type, inferrableBound, typeMappings, newMalleable);
        } else {
            throw new TypeInferenceException(inferFrom + " cannot be implicitly cast to " + type + ", thus it is impossible to infer type variables for " + inferFrom);
        }
    }

    private static void inferTypeVariables(ParameterizedType type, Type inferFrom, Map<TypeVariable<?>, TypeMapping> typeMappings) {
        if (type.equals(inferFrom)) {
            return;
        }
        if (inferFrom instanceof WildcardType) {
            inferFrom = GenericAssignability.getInferrableBound((WildcardType)inferFrom);
        }
        if (Any.is((Object)inferFrom)) {
            GenericAssignability.mapTypeVarsToAny(type, typeMappings);
            return;
        }
        Type superInferFrom = Types.superTypeOf((Type)inferFrom, (Class)Types.raw((Type)type));
        if (superInferFrom instanceof ParameterizedType) {
            ParameterizedType paramInferFrom = (ParameterizedType)superInferFrom;
            if (!Types.isRecursive((Type)paramInferFrom)) {
                GenericAssignability.inferTypeVariables(type.getActualTypeArguments(), paramInferFrom.getActualTypeArguments(), typeMappings, false);
            } else {
                GenericAssignability.inferTypeVariables(type.getActualTypeArguments(), new Type[]{paramInferFrom.getRawType()}, typeMappings, false);
            }
        } else if (superInferFrom instanceof Class) {
            TypeVarAssigns typeVarAssigns = new TypeVarAssigns(typeMappings);
            Type mappedType = Types.unroll((Type)type, (Map)typeVarAssigns);
            if (!Types.isAssignable((Type)superInferFrom, (Type)mappedType, (Map)typeVarAssigns)) {
                throw new TypeInferenceException(inferFrom + " cannot be implicitly cast to " + mappedType + ", thus it is impossible to infer type variables for " + inferFrom);
            }
            GenericAssignability.mapTypeVarsToAny(type, typeMappings);
        } else if (superInferFrom == null) {
            if (Object.class.equals((Object)inferFrom) || inferFrom instanceof TypeVariable && Object.class.equals((Object)((TypeVariable)inferFrom).getBounds()[0])) {
                GenericAssignability.mapTypeVarsToAny(type, typeMappings);
                return;
            }
            Type superTypeOfType = Types.superTypeOf((Type)type, (Class)Types.raw((Type)inferFrom));
            if (superTypeOfType == null) {
                throw new TypeInferenceException(inferFrom + " cannot be implicitly cast to " + type + ", thus it is impossible to infer type variables for " + inferFrom);
            }
            GenericAssignability.inferTypeVariables(superTypeOfType, inferFrom, typeMappings, false);
            GenericAssignability.mapTypeVarsToAny(type, typeMappings);
        } else {
            throw new IllegalStateException(superInferFrom + " is the supertype of " + inferFrom + " with respect to " + type + ", however this cannot be (since " + type + " is a ParamterizedType)! (Only a ParameterizedType, Class, or null can be returned from Types.getExactSuperType when it is called with a ParameterizedType!)");
        }
    }

    private static void inferTypeVariables(Type type, Type inferFrom, Map<TypeVariable<?>, TypeMapping> typeMappings, boolean malleable) {
        if (type instanceof TypeVariable) {
            GenericAssignability.inferTypeVariables((TypeVariable)type, inferFrom, typeMappings, malleable);
        } else if (type instanceof ParameterizedType) {
            GenericAssignability.inferTypeVariables((ParameterizedType)type, inferFrom, typeMappings);
        } else if (type instanceof WildcardType) {
            GenericAssignability.inferTypeVariables((WildcardType)type, inferFrom, typeMappings);
        } else if (type instanceof GenericArrayType) {
            GenericAssignability.inferTypeVariablesFromGenericArray((GenericArrayType)type, inferFrom, typeMappings, malleable);
        } else if (type instanceof Class) {
            GenericAssignability.inferTypeVariables((Class)type, inferFrom, typeMappings);
        }
    }

    private static void inferTypeVariables(Type[] types, Type[] inferFroms, Map<TypeVariable<?>, TypeMapping> typeMappings, boolean malleable) {
        if (typeMappings == null) {
            throw new IllegalArgumentException("Type Variable map is null, cannot store mappings of TypeVariables to Types!");
        }
        if (types.length != inferFroms.length) {
            throw new TypeInferenceException("Could not infer type variables: Type arrays must be of the same size");
        }
        for (int i = 0; i < types.length; ++i) {
            GenericAssignability.inferTypeVariables(types[i], inferFroms[i], typeMappings, malleable);
        }
        TypeVarAssigns typeVarAssigns = new TypeVarAssigns(typeMappings);
        if (!Types.varsSatisfied((Map)typeVarAssigns)) {
            throw new TypeInferenceException();
        }
    }

    private static void inferTypeVariables(TypeVariable<?> type, Type inferFrom, Map<TypeVariable<?>, TypeMapping> typeMappings, boolean malleable) {
        TypeMapping typeData = typeMappings.get(type);
        if (typeData != null) {
            typeData.refine(inferFrom, malleable);
        } else {
            GenericAssignability.resolveTypeInMap(type, inferFrom, typeMappings, malleable);
            for (Type bound : type.getBounds()) {
                if (bound instanceof TypeVariable && typeMappings.get(bound) != null) {
                    Type typeAssignForBound = typeMappings.get(bound).getType();
                    if (Types.isAssignable((Type)inferFrom, (Type)typeAssignForBound)) continue;
                    throw new TypeInferenceException();
                }
                if (Types.isRecursiveBound(type, (Type)bound)) continue;
                if (bound instanceof TypeVariable) {
                    TypeVariable tv = (TypeVariable)bound;
                    GenericAssignability.inferTypeVariables(tv, inferFrom, typeMappings, true);
                    continue;
                }
                GenericAssignability.inferTypeVariables(bound, inferFrom, typeMappings);
            }
        }
    }

    private static void inferTypeVariables(WildcardType type, Type inferFrom, Map<TypeVariable<?>, TypeMapping> typeMappings) {
        Type inferrableBound = GenericAssignability.getInferrableBound(type);
        if (inferFrom instanceof WildcardType) {
            inferFrom = GenericAssignability.getInferrableBound((WildcardType)inferFrom);
        }
        if (inferrableBound instanceof TypeVariable) {
            GenericAssignability.resolveTypeInMap((TypeVariable)inferrableBound, inferFrom, typeMappings, true);
        } else if (inferrableBound instanceof ParameterizedType) {
            ParameterizedType parameterizedUpperBound = (ParameterizedType)inferrableBound;
            GenericAssignability.inferTypeVariables(parameterizedUpperBound, inferFrom, typeMappings, true);
        }
    }

    private static void mapTypeVarsToAny(Type type, Map<TypeVariable<?>, TypeMapping> typeMappings) {
        block7: {
            block9: {
                block8: {
                    Type[] typeParams;
                    block6: {
                        if (!Types.containsTypeVars((Type)type)) {
                            return;
                        }
                        if (!(type instanceof TypeVariable)) break block6;
                        if (typeMappings.containsKey(type)) {
                            return;
                        }
                        TypeVariable typeVar = (TypeVariable)type;
                        typeMappings.put(typeVar, GenericAssignability.suitableTypeMapping(typeVar, Any.class, true));
                        break block7;
                    }
                    if (!(type instanceof ParameterizedType)) break block8;
                    ParameterizedType pType = (ParameterizedType)type;
                    for (Type typeParam : typeParams = pType.getActualTypeArguments()) {
                        GenericAssignability.mapTypeVarsToAny(typeParam, typeMappings);
                    }
                    break block7;
                }
                if (!(type instanceof WildcardType)) break block9;
                WildcardType wildcard = (WildcardType)type;
                for (Type lowerBound : wildcard.getLowerBounds()) {
                    GenericAssignability.mapTypeVarsToAny(lowerBound, typeMappings);
                }
                for (Type upperBound : wildcard.getUpperBounds()) {
                    GenericAssignability.mapTypeVarsToAny(upperBound, typeMappings);
                }
                break block7;
            }
            if (!(type instanceof Class)) break block7;
            Class clazz = (Class)type;
            for (TypeVariable typeParam : clazz.getTypeParameters()) {
                GenericAssignability.mapTypeVarsToAny(typeParam, typeMappings);
            }
        }
    }

    private static void resolveTypeInMap(TypeVariable<?> typeVar, Type newType, Map<TypeVariable<?>, TypeMapping> typeMappings, boolean malleability) {
        if (typeMappings.containsKey(typeVar)) {
            typeMappings.get(typeVar).refine(newType, malleability);
        } else {
            typeMappings.put(typeVar, GenericAssignability.suitableTypeMapping(typeVar, newType, malleability));
        }
    }

    private static TypeMapping suitableTypeMapping(TypeVariable<?> typeVar, Type newType, boolean malleability) {
        if (newType instanceof WildcardType) {
            return new WildcardTypeMapping(typeVar, (WildcardType)newType, malleability);
        }
        return new TypeMapping(typeVar, newType, malleability);
    }

    static void inferTypeVariables(Type type, Type inferFrom, Map<TypeVariable<?>, TypeMapping> typeMappings) {
        GenericAssignability.inferTypeVariables(type, inferFrom, typeMappings, false);
    }

    static void inferTypeVariablesWithTypeMappings(Type[] type, Type[] inferFrom, Map<TypeVariable<?>, TypeMapping> typeMappings) {
        GenericAssignability.inferTypeVariables(type, inferFrom, typeMappings, false);
    }
}

