/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.types.infer;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.scijava.types.infer.TypeMapping;
import org.scijava.types.infer.WildcardTypeMapping;

class TypeVarAssigns
implements Map<TypeVariable<?>, Type> {
    private Map<TypeVariable<?>, TypeMapping> map;

    private static TypeMapping suitableTypeMapping(TypeVariable<?> typeVar, Type newType, boolean malleability) {
        if (newType instanceof WildcardType) {
            return new WildcardTypeMapping(typeVar, (WildcardType)newType, malleability);
        }
        return new TypeMapping(typeVar, newType, malleability);
    }

    TypeVarAssigns(Map<TypeVariable<?>, TypeMapping> map) {
        this.map = map;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<TypeVariable<?>, Type>> entrySet() {
        return this.map.entrySet().stream().map(e -> new Map.Entry<TypeVariable<?>, Type>((Map.Entry)e){
            final /* synthetic */ Map.Entry val$e;
            {
                this.val$e = entry;
            }

            @Override
            public TypeVariable<?> getKey() {
                return (TypeVariable)this.val$e.getKey();
            }

            @Override
            public Type getValue() {
                return TypeVarAssigns.this.get(this.getKey());
            }

            @Override
            public Type setValue(Type value) {
                return TypeVarAssigns.this.put((TypeVariable<?>)this.getKey(), value);
            }
        }).collect(Collectors.toSet());
    }

    @Override
    public Type get(Object key) {
        TypeMapping value = this.map.get(key);
        return value == null ? null : value.getType();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<TypeVariable<?>> keySet() {
        return this.map.keySet();
    }

    @Override
    public Type put(TypeVariable<?> typeVar, Type type) {
        TypeMapping previousMapping = this.map.put(typeVar, TypeVarAssigns.suitableTypeMapping(typeVar, type, this.isMalleable(typeVar)));
        return previousMapping == null ? null : previousMapping.getType();
    }

    @Override
    public void putAll(Map<? extends TypeVariable<?>, ? extends Type> m) {
        for (Map.Entry<TypeVariable<?>, Type> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Type putIfAbsent(TypeVariable<?> typeVar, Type type) {
        if (!this.map.containsKey(typeVar)) {
            return this.put(typeVar, type);
        }
        return this.get(typeVar);
    }

    @Override
    public Type remove(Object key) {
        TypeMapping value = this.map.remove(key);
        return value == null ? null : value.getType();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Type> values() {
        return this.map.values().stream().map(v -> v.getType()).collect(Collectors.toList());
    }

    private boolean isMalleable(TypeVariable<?> typeVar) {
        return this.map.containsKey(typeVar) && this.map.get(typeVar).malleable;
    }
}

