/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.types.infer;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.scijava.common3.Types;
import org.scijava.types.infer.TypeInferenceException;
import org.scijava.types.infer.TypeMapping;

class WildcardTypeMapping
extends TypeMapping {
    private List<Type> lowerBoundList = new ArrayList<Type>();

    private static Type getLowerBound(WildcardType newType) {
        Object[] lowerBounds = newType.getLowerBounds();
        if (lowerBounds.length == 0) {
            return null;
        }
        if (lowerBounds.length == 1) {
            return lowerBounds[0];
        }
        throw new TypeInferenceException(newType + " is an impossible WildcardType. The Java language specification currently prevents multiple lower bounds " + Arrays.toString(lowerBounds));
    }

    private static Type getUpperBound(WildcardType newType) {
        Object[] upperBounds = newType.getUpperBounds();
        if (upperBounds.length == 0) {
            return Object.class;
        }
        if (upperBounds.length == 1) {
            return upperBounds[0];
        }
        throw new TypeInferenceException(newType + " is an impossible WildcardType. The Java language specification currently prevents multiple upper bounds " + Arrays.toString(upperBounds));
    }

    WildcardTypeMapping(TypeVariable<?> typeVar, WildcardType mappedType, boolean malleable) {
        super(typeVar, WildcardTypeMapping.getUpperBound(mappedType), malleable);
        Type mappedTypeLowerBound = WildcardTypeMapping.getLowerBound(mappedType);
        if (mappedTypeLowerBound != null) {
            this.lowerBoundList.add(mappedTypeLowerBound);
        }
    }

    @Override
    public void refine(Type otherType, boolean newTypeMalleability) {
        if (otherType instanceof WildcardType) {
            this.refineWildcard((WildcardType)otherType, newTypeMalleability);
        } else {
            super.refine(otherType, newTypeMalleability);
        }
        for (Type lowerBound : this.lowerBoundList) {
            if (Types.isAssignable((Type)lowerBound, (Type)this.mappedType)) continue;
            throw new TypeInferenceException(this.typeVar + " cannot simultaneously be mapped to " + otherType + " and " + this.mappedType);
        }
    }

    private void refineWildcard(WildcardType otherType, boolean newTypeMalleability) {
        Type otherLowerBound = WildcardTypeMapping.getLowerBound(otherType);
        if (otherLowerBound != null) {
            this.lowerBoundList.add(otherLowerBound);
        }
        Type otherUpperBound = WildcardTypeMapping.getUpperBound(otherType);
        super.refine(otherUpperBound, newTypeMalleability);
    }
}

