/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.processor;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

@FunctionalInterface
public interface TaskLimiter {
    public Token request(String var1) throws InterruptedException;

    public static TaskLimiter noop() {
        return topic -> () -> {};
    }

    public static TaskLimiter bound(int size) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(size);
        return topic -> {
            queue.put(topic);
            AtomicBoolean alive = new AtomicBoolean(true);
            return () -> {
                if (alive.getAndSet(false)) {
                    queue.remove(topic);
                }
            };
        };
    }

    @FunctionalInterface
    public static interface Token {
        public void release();
    }
}

