/*
 * Decompiled with CFR 0.152.
 */
package com.blockscore.models;

import com.blockscore.models.Address;
import com.blockscore.models.EntityType;
import com.blockscore.models.PaginatedResult;
import com.blockscore.models.WatchlistHit;
import com.blockscore.models.WatchlistSearchResults;
import com.blockscore.models.base.BasicResponse;
import com.blockscore.net.BlockscoreApiClient;
import com.blockscore.net.BlockscoreRestAdapter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Candidate
extends BasicResponse {
    @JsonIgnore
    private BlockscoreRestAdapter restAdapter;
    @JsonProperty(value="name_first")
    @NotNull
    private String firstName;
    @JsonProperty(value="name_middle")
    @Nullable
    private String middleName;
    @JsonProperty(value="name_last")
    @NotNull
    private String lastName;
    @JsonProperty(value="note")
    @Nullable
    private String note;
    @JsonProperty(value="ssn")
    @Nullable
    private String socialSecurityNumber;
    @JsonProperty(value="passport")
    @Nullable
    private String passport;
    @JsonProperty(value="date_of_birth")
    @Nullable
    private Date dateOfBirth;
    @JsonProperty(value="address_street1")
    @NotNull
    private String addressStreet1;
    @JsonProperty(value="address_street2")
    @Nullable
    private String addressStreet2;
    @JsonProperty(value="address_city")
    @NotNull
    private String addressCity;
    @JsonProperty(value="address_subdivision")
    @NotNull
    private String addressSubdivision;
    @JsonProperty(value="address_postal_code")
    @NotNull
    private String addressPostalCode;
    @JsonProperty(value="address_country_code")
    @NotNull
    private String addressCountryCode;

    protected Candidate() {
    }

    public Candidate save() {
        this.restAdapter.updateCandidate(this.getId(), this);
        return this;
    }

    public void delete() {
        this.restAdapter.deleteCandidate(this.getId());
    }

    public List<Candidate> getRevisionHistory() {
        List<Candidate> candidates = this.restAdapter.getCandidateHistory(this.getId());
        for (Candidate candidate : candidates) {
            candidate.setAdapter(this.restAdapter);
        }
        return Collections.unmodifiableList(candidates);
    }

    public PaginatedResult<WatchlistHit> getPastHits() {
        return this.restAdapter.getCandidateHits(this.getId());
    }

    public PaginatedResult<WatchlistHit> searchWatchlists() {
        return this.searchWatchlists(null, null);
    }

    public PaginatedResult<WatchlistHit> searchWatchlists(Double similarityThreshold) {
        return this.searchWatchlists(null, similarityThreshold);
    }

    public PaginatedResult<WatchlistHit> searchWatchlists(EntityType entityType) {
        return this.searchWatchlists(entityType, null);
    }

    public PaginatedResult<WatchlistHit> searchWatchlists(EntityType entityType, Double similarityThreshold) {
        HashMap<String, String> queryOptions = new HashMap<String, String>();
        queryOptions.put("candidate_id", this.getId());
        if (entityType != null) {
            queryOptions.put("match_type", String.valueOf((Object)entityType));
        }
        if (similarityThreshold != null) {
            queryOptions.put("similarity_threshold", String.valueOf(similarityThreshold));
        }
        WatchlistSearchResults results = this.restAdapter.searchWatchlists(queryOptions);
        return new PaginatedResult<WatchlistHit>(results.getMatches(), results.getCount(), false);
    }

    @NotNull
    public Candidate setFirstName(@NotNull String firstName) {
        this.firstName = firstName;
        return this;
    }

    @NotNull
    public Candidate setMiddleName(@NotNull String middleName) {
        this.middleName = middleName;
        return this;
    }

    @NotNull
    public Candidate setLastName(@NotNull String lastName) {
        this.lastName = lastName;
        return this;
    }

    @NotNull
    public Candidate setNote(@Nullable String note) {
        this.note = note;
        return this;
    }

    @NotNull
    public Candidate setSsn(@Nullable String ssn) {
        this.socialSecurityNumber = ssn;
        return this;
    }

    @NotNull
    public Candidate setPassport(@Nullable String passport) {
        this.passport = passport;
        return this;
    }

    @NotNull
    public Candidate setDateOfBirth(@Nullable Date dateOfBirth) {
        if (dateOfBirth == null) {
            this.dateOfBirth = null;
            return this;
        }
        this.dateOfBirth = new Date(dateOfBirth.getTime());
        return this;
    }

    public Candidate setAddress(@NotNull Address address) {
        this.addressStreet1 = address.getStreet1();
        this.addressStreet2 = address.getStreet2();
        this.addressCity = address.getCity();
        this.addressSubdivision = address.getSubdivision();
        this.addressPostalCode = address.getPostalCode();
        this.addressCountryCode = address.getCountryCode();
        return this;
    }

    @Nullable
    public String getFirstName() {
        return this.firstName;
    }

    @Nullable
    public String getMiddleName() {
        return this.middleName;
    }

    @Nullable
    public String getLastName() {
        return this.lastName;
    }

    @Nullable
    public String getNote() {
        return this.note;
    }

    @Nullable
    public String getSsn() {
        return this.socialSecurityNumber;
    }

    @Nullable
    public String getPassport() {
        return this.passport;
    }

    @Nullable
    public Date getDateOfBirth() {
        if (this.dateOfBirth == null) {
            return null;
        }
        return new Date(this.dateOfBirth.getTime());
    }

    @Nullable
    public Address getAddress() {
        Address addressObject = new Address(this.addressStreet1, this.addressStreet2, this.addressCity, this.addressSubdivision, this.addressPostalCode, this.addressCountryCode);
        return addressObject;
    }

    public void setAdapter(BlockscoreRestAdapter restAdapter) {
        this.restAdapter = restAdapter;
    }

    public static class Builder {
        private BlockscoreRestAdapter restAdapter;
        private Candidate candidate;

        public Builder(BlockscoreApiClient client) {
            this.restAdapter = client.getAdapter();
            this.candidate = new Candidate();
        }

        @NotNull
        public Builder setFirstName(@NotNull String firstName) {
            this.candidate.setFirstName(firstName);
            return this;
        }

        @NotNull
        public Builder setMiddleName(@NotNull String middleName) {
            this.candidate.setMiddleName(middleName);
            return this;
        }

        @NotNull
        public Builder setLastName(@NotNull String lastName) {
            this.candidate.setLastName(lastName);
            return this;
        }

        @NotNull
        public Builder setNote(@Nullable String note) {
            this.candidate.setNote(note);
            return this;
        }

        @NotNull
        public Builder setSsn(@Nullable String ssn) {
            this.candidate.setSsn(ssn);
            return this;
        }

        @NotNull
        public Builder setPassport(@Nullable String passport) {
            this.candidate.setPassport(passport);
            return this;
        }

        @NotNull
        public Builder setDateOfBirth(@Nullable Date dateOfBirth) {
            this.candidate.setDateOfBirth(dateOfBirth);
            return this;
        }

        public Builder setAddress(@NotNull Address address) {
            this.candidate.setAddress(address);
            return this;
        }

        public Candidate create() {
            this.candidate = this.restAdapter.createCandidate(this.candidate);
            this.candidate.setAdapter(this.restAdapter);
            return this.candidate;
        }
    }
}

