/*
 * Decompiled with CFR 0.152.
 */
package com.blockscore.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PaginatedResult<T> {
    @JsonProperty(value="total_count")
    private int totalCount;
    @JsonProperty(value="has_more")
    @NotNull
    private boolean hasMore;
    @JsonProperty(value="data")
    @NotNull
    private List<T> data;

    private PaginatedResult() {
    }

    public PaginatedResult(List<T> data, int totalCount, boolean hasMore) {
        this.totalCount = totalCount;
        this.hasMore = hasMore;
        this.data = data;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    @NotNull
    public List<T> getData() {
        return Collections.unmodifiableList(this.data);
    }
}

