/*
 * Decompiled with CFR 0.152.
 */
package com.blockscore.models;

import com.blockscore.models.AnswerSet;
import com.blockscore.models.Question;
import com.blockscore.models.base.BasicResponse;
import com.blockscore.net.BlockscoreRestAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QuestionSet
extends BasicResponse {
    @JsonProperty(value="person_id")
    @NotNull
    private String personId;
    @JsonProperty(value="score")
    private Integer score;
    @JsonProperty(value="expired")
    private boolean expired;
    @JsonProperty(value="time_limit")
    private Long timeLimit;
    @JsonProperty(value="questions")
    @NotNull
    private List<Question> questions;
    private BlockscoreRestAdapter restAdapter;

    @NotNull
    public void score(@NotNull AnswerSet answers) {
        QuestionSet scoredSet = this.restAdapter.scoreQuestionSet(this.getId(), answers);
        this.expired = scoredSet.isExpired();
        this.score = scoredSet.getScore();
    }

    void setAdapter(BlockscoreRestAdapter restAdapter) {
        this.restAdapter = restAdapter;
    }

    @NotNull
    public String getPersonId() {
        return this.personId;
    }

    public Integer getScore() {
        return this.score;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public Long getTimeLimit() {
        return this.timeLimit;
    }

    @NotNull
    public List<Question> getQuestions() {
        return Collections.unmodifiableList(this.questions);
    }
}

