/*
 * Decompiled with CFR 0.152.
 */
package com.blockscore.models;

import com.blockscore.models.Address;
import com.blockscore.models.BirthRange;
import com.blockscore.models.Document;
import com.blockscore.models.EntityType;
import com.blockscore.models.NameResult;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchlistHit {
    @JsonProperty(value="watchlist_name")
    @NotNull
    private String watchlist;
    @JsonProperty(value="entry_type")
    @NotNull
    private String entryType;
    @JsonProperty(value="matching_info")
    @Nullable
    private String[] matchingInfo;
    @JsonProperty(value="confidence")
    @NotNull
    private Double confidence;
    @JsonProperty(value="url")
    @Nullable
    private String url;
    @JsonProperty(value="notes")
    @Nullable
    private String notes;
    @JsonProperty(value="title")
    @Nullable
    private String title;
    @JsonProperty(value="name_full")
    @NotNull
    private String fullName;
    @JsonProperty(value="alternate_names")
    @Nullable
    private String alternateNames;
    @JsonProperty(value="date_of_birth")
    @Nullable
    private Date dateOfBirth;
    @JsonProperty(value="passport")
    @Nullable
    private String passportNumbers;
    @JsonProperty(value="ssn")
    @Nullable
    private String ssn;
    @JsonProperty(value="address_street1")
    @Nullable
    private String addressStreet1;
    @JsonProperty(value="address_street2")
    @Nullable
    private String addressStreet2;
    @JsonProperty(value="address_city")
    @Nullable
    private String addressCity;
    @JsonProperty(value="address_state")
    @Nullable
    private String addressState;
    @JsonProperty(value="address_postal_code")
    @Nullable
    private String addressPostalCode;
    @JsonProperty(value="address_country_code")
    @Nullable
    private String addressCountryCode;
    @JsonProperty(value="address_raw")
    @Nullable
    private String rawAddress;
    @JsonProperty(value="names")
    @NotNull
    private List<NameResult> names;
    @JsonProperty(value="births")
    @NotNull
    private List<BirthRange> births;
    @JsonProperty(value="documents")
    @NotNull
    private List<Document> documents;
    @JsonProperty(value="addresses")
    @NotNull
    private List<Address> addresses;

    @NotNull
    public String getWatchlist() {
        return this.watchlist;
    }

    @NotNull
    public EntityType getEntryType() {
        return EntityType.toEnum(this.entryType);
    }

    @NotNull
    public String[] getMatchingInfo() {
        if (this.matchingInfo == null) {
            return new String[0];
        }
        return Arrays.copyOf(this.matchingInfo, this.matchingInfo.length);
    }

    public double getConfidence() {
        return this.confidence;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getNotes() {
        return this.notes;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public String getName() {
        return this.fullName;
    }

    @NotNull
    public String getAlternateNames() {
        return this.alternateNames;
    }

    @Nullable
    public Date getDateOfBirth() {
        if (this.dateOfBirth == null) {
            return null;
        }
        return new Date(this.dateOfBirth.getTime());
    }

    @Nullable
    public String getSsn() {
        return this.ssn;
    }

    @Nullable
    public String getPassports() {
        return this.passportNumbers;
    }

    @Nullable
    public Address getAddress() {
        return new Address(this.addressStreet1, this.addressStreet2, this.addressCity, this.addressState, this.addressPostalCode, this.addressCountryCode);
    }

    @Nullable
    public String getRawAddress() {
        return this.rawAddress;
    }

    @NotNull
    public List<NameResult> getNames() {
        return Collections.unmodifiableList(this.names);
    }

    @NotNull
    public List<BirthRange> getBirths() {
        return Collections.unmodifiableList(this.births);
    }

    @NotNull
    public List<Document> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    @NotNull
    public List<Address> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }
}

