/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.model.query;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.commons.lang3.Validate;

public class AttachmentQuery {
    private File asset;
    private String url;
    private String description;

    public String getMimeType() throws IOException {
        Validate.notNull(this.asset, "Cannot get MIME type since asset is null", new Object[0]);
        return Files.probeContentType(this.asset.toPath());
    }

    AttachmentQuery(File asset, String url, String description) {
        this.asset = asset;
        this.url = url;
        this.description = description;
    }

    public static AttachmentQueryBuilder builder() {
        return new AttachmentQueryBuilder();
    }

    public File asset() {
        return this.asset;
    }

    public String url() {
        return this.url;
    }

    public String description() {
        return this.description;
    }

    public AttachmentQuery asset(File asset) {
        this.asset = asset;
        return this;
    }

    public AttachmentQuery url(String url) {
        this.url = url;
        return this;
    }

    public AttachmentQuery description(String description) {
        this.description = description;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttachmentQuery)) {
            return false;
        }
        AttachmentQuery other = (AttachmentQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$asset = this.asset();
        File other$asset = other.asset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        String this$url = this.url();
        String other$url = other.url();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$description = this.description();
        String other$description = other.description();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttachmentQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $asset = this.asset();
        result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
        String $url = this.url();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $description = this.description();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "AttachmentQuery(asset=" + this.asset() + ", url=" + this.url() + ", description=" + this.description() + ")";
    }

    public static class AttachmentQueryBuilder {
        private File asset;
        private String url;
        private String description;

        AttachmentQueryBuilder() {
        }

        public AttachmentQueryBuilder asset(File asset) {
            this.asset = asset;
            return this;
        }

        public AttachmentQueryBuilder url(String url) {
            this.url = url;
            return this;
        }

        public AttachmentQueryBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AttachmentQuery build() {
            return new AttachmentQuery(this.asset, this.url, this.description);
        }

        public String toString() {
            return "AttachmentQuery.AttachmentQueryBuilder(asset=" + this.asset + ", url=" + this.url + ", description=" + this.description + ")";
        }
    }
}

