/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.handler.call;

import com.exsoloscript.challonge.handler.call.ChallongeApiCall;
import com.exsoloscript.challonge.handler.call.RetrofitChallongeApiCallFactory;
import com.exsoloscript.challonge.handler.retrofit.RetrofitServiceProvider;
import com.exsoloscript.challonge.handler.retrofit.RetrofitTournamentHandler;
import com.exsoloscript.challonge.model.Tournament;
import com.exsoloscript.challonge.model.enumeration.TournamentType;
import com.exsoloscript.challonge.model.enumeration.query.TournamentQueryState;
import com.exsoloscript.challonge.model.query.TournamentQuery;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@Singleton
public class TournamentHandler {
    private final RetrofitTournamentHandler tournamentHandler;
    private final RetrofitChallongeApiCallFactory factory;

    @Inject
    TournamentHandler(RetrofitServiceProvider provider, RetrofitChallongeApiCallFactory factory) {
        this.tournamentHandler = provider.createService(RetrofitTournamentHandler.class);
        this.factory = factory;
    }

    public ChallongeApiCall<List<Tournament>> getTournaments() {
        return this.getTournaments(null, null, null, null, null);
    }

    public ChallongeApiCall<List<Tournament>> getTournaments(TournamentQueryState state, TournamentType type, String createdAfter, String createdBefore, String subdomain) {
        return this.factory.createApiCall(this.tournamentHandler.getTournaments(state, type, createdAfter, createdBefore, subdomain));
    }

    public ChallongeApiCall<Tournament> getTournament(String name, boolean includeParticipants, boolean includeMatches) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)name), (String)"Tournament string is required", (Object[])new Object[0]);
        return this.factory.createApiCall(this.tournamentHandler.getTournament(name, includeParticipants ? 1 : 0, includeMatches ? 1 : 0));
    }

    public ChallongeApiCall<Tournament> getTournament(String subdomain, String name, boolean includeParticipants, boolean includeMatches) {
        return this.getTournament(subdomain + "-" + name, includeParticipants, includeMatches);
    }

    public ChallongeApiCall<Tournament> createTournament(TournamentQuery tournament) {
        return this.factory.createApiCall(this.tournamentHandler.createTournament(tournament));
    }

    public ChallongeApiCall<Tournament> updateTournament(String name, TournamentQuery tournament) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)name), (String)"Tournament string is required", (Object[])new Object[0]);
        return this.factory.createApiCall(this.tournamentHandler.updateTournament(name, tournament));
    }

    public ChallongeApiCall<Tournament> updateTournament(String subdomain, String name, TournamentQuery tournament) {
        return this.updateTournament(subdomain + "-" + name, tournament);
    }

    public ChallongeApiCall<Tournament> deleteTournament(String name) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)name), (String)"Tournament string is required", (Object[])new Object[0]);
        return this.factory.createApiCall(this.tournamentHandler.deleteTournament(name));
    }

    public ChallongeApiCall<Tournament> deleteTournament(String subdomain, String name) {
        return this.deleteTournament(subdomain + "-" + name);
    }

    public ChallongeApiCall<Tournament> processCheckIns(String name, boolean includeParticipants, boolean includeMatches) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)name), (String)"Tournament string is required", (Object[])new Object[0]);
        return this.factory.createApiCall(this.tournamentHandler.processCheckIns(name, includeParticipants ? 1 : 0, includeMatches ? 1 : 0));
    }

    public ChallongeApiCall<Tournament> processCheckIns(String subdomain, String name, boolean includeParticipants, boolean includeMatches) {
        return this.processCheckIns(subdomain + "-" + name, includeParticipants, includeMatches);
    }

    public ChallongeApiCall<Tournament> abortCheckIn(String name, boolean includeParticipants, boolean includeMatches) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)name), (String)"Tournament string is required", (Object[])new Object[0]);
        return this.factory.createApiCall(this.tournamentHandler.abortCheckIn(name, includeParticipants ? 1 : 0, includeMatches ? 1 : 0));
    }

    public ChallongeApiCall<Tournament> abortCheckIn(String subdomain, String name, boolean includeParticipants, boolean includeMatches) {
        return this.abortCheckIn(subdomain + "-" + name, includeParticipants, includeMatches);
    }

    public ChallongeApiCall<Tournament> startTournament(String name, boolean includeParticipants, boolean includeMatches) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)name), (String)"Tournament string is required", (Object[])new Object[0]);
        return this.factory.createApiCall(this.tournamentHandler.startTournament(name, includeParticipants ? 1 : 0, includeMatches ? 1 : 0));
    }

    public ChallongeApiCall<Tournament> startTournament(String subdomain, String name, boolean includeParticipants, boolean includeMatches) {
        return this.startTournament(subdomain + "-" + name, includeParticipants, includeMatches);
    }

    public ChallongeApiCall<Tournament> finalizeTournament(String name, boolean includeParticipants, boolean includeMatches) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)name), (String)"Tournament string is required", (Object[])new Object[0]);
        return this.factory.createApiCall(this.tournamentHandler.finalizeTournament(name, includeParticipants ? 1 : 0, includeMatches ? 1 : 0));
    }

    public ChallongeApiCall<Tournament> finalizeTournament(String subdomain, String name, boolean includeParticipants, boolean includeMatches) {
        return this.finalizeTournament(subdomain + "-" + name, includeParticipants, includeMatches);
    }

    public ChallongeApiCall<Tournament> resetTournament(String name, boolean includeParticipants, boolean includeMatches) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)name), (String)"Tournament string is required", (Object[])new Object[0]);
        return this.factory.createApiCall(this.tournamentHandler.resetTournament(name, includeParticipants ? 1 : 0, includeMatches ? 1 : 0));
    }

    public ChallongeApiCall<Tournament> resetTournament(String subdomain, String name, boolean includeParticipants, boolean includeMatches) {
        return this.resetTournament(subdomain + "-" + name, includeParticipants, includeMatches);
    }
}

