/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.handler.retrofit;

import com.exsoloscript.challonge.model.Participant;
import com.exsoloscript.challonge.model.query.ParticipantQuery;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface RetrofitParticipantHandler {
    @GET(value="tournaments/{tournament}/participants.json")
    public Call<List<Participant>> getParticipants(@Path(value="tournament") String var1);

    @GET(value="tournaments/{tournament}/participants/{participant_id}.json")
    public Call<Participant> getParticipant(@Path(value="tournament") String var1, @Path(value="participant_id") int var2, @Query(value="include_matches") int var3);

    @POST(value="tournaments/{tournament}/participants.json")
    public Call<Participant> addParticipant(@Path(value="tournament") String var1, @Body ParticipantQuery var2);

    @POST(value="tournaments/{tournament}/participants/bulk_add.json")
    public Call<List<Participant>> bulkAddParticipants(@Path(value="tournament") String var1, @Body List<ParticipantQuery> var2);

    @PUT(value="tournaments/{tournament}/participants/{participant_id}.json")
    public Call<Participant> updateParticipant(@Path(value="tournament") String var1, @Path(value="participant_id") int var2, @Body ParticipantQuery var3);

    @POST(value="tournaments/{tournament}/participants/{participant_id}/check_in.json")
    public Call<Participant> checkInParticipant(@Path(value="tournament") String var1, @Path(value="participant_id") int var2);

    @POST(value="tournaments/{tournament}/participants/{participant_id}/undo_check_in.json")
    public Call<Participant> undoParticipantCheckIn(@Path(value="tournament") String var1, @Path(value="participant_id") int var2);

    @DELETE(value="tournaments/{tournament}/participants/{participant_id}.json")
    public Call<Participant> deleteParticipant(@Path(value="tournament") String var1, @Path(value="participant_id") int var2);

    @POST(value="tournaments/{tournament}/participants/randomize.json")
    public Call<List<Participant>> randomizeParticipants(@Path(value="tournament") String var1);
}

